/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.amazon.iam.deployment;

import io.quarkiverse.amazon.common.deployment.AbstractAmazonServiceProcessor;
import io.quarkiverse.amazon.common.deployment.AmazonClientExtensionBuildItem;
import io.quarkiverse.amazon.common.deployment.AmazonClientExtensionBuilderInstanceBuildItem;
import io.quarkiverse.amazon.common.deployment.RequireAmazonClientInjectionBuildItem;
import io.quarkiverse.amazon.common.runtime.AmazonClientRecorder;
import io.quarkiverse.amazon.common.runtime.HasSdkBuildTimeConfig;
import io.quarkiverse.amazon.common.runtime.HasTransportBuildTimeConfig;
import io.quarkiverse.amazon.iam.runtime.IamBuildTimeConfig;
import io.quarkiverse.amazon.iam.runtime.IamRecorder;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import java.util.List;
import org.jboss.jandex.DotName;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.IamAsyncClientBuilder;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.IamClientBuilder;

public class IamProcessor
extends AbstractAmazonServiceProcessor {
    private static final String AMAZON_CLIENT_NAME = "amazon-sdk-iam";
    IamBuildTimeConfig buildTimeConfig;

    protected String amazonServiceClientName() {
        return AMAZON_CLIENT_NAME;
    }

    protected String configName() {
        return "iam";
    }

    protected DotName syncClientName() {
        return DotName.createSimple((String)IamClient.class.getName());
    }

    protected Class<?> syncClientBuilderClass() {
        return IamClientBuilder.class;
    }

    protected DotName asyncClientName() {
        return DotName.createSimple((String)IamAsyncClient.class.getName());
    }

    protected Class<?> asyncClientBuilderClass() {
        return IamAsyncClientBuilder.class;
    }

    protected String builtinInterceptorsPath() {
        return "software/amazon/awssdk/services/iam/execution.interceptors";
    }

    protected HasTransportBuildTimeConfig transportBuildTimeConfig() {
        return this.buildTimeConfig;
    }

    protected HasSdkBuildTimeConfig sdkBuildTimeConfig() {
        return this.buildTimeConfig;
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void createBuilders(IamRecorder recorder, List<RequireAmazonClientInjectionBuildItem> amazonClientInjections, BuildProducer<AmazonClientExtensionBuilderInstanceBuildItem> builderIstances) {
        this.createExtensionBuilders((AmazonClientRecorder)recorder, amazonClientInjections, builderIstances);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setup(IamRecorder recorder, BuildProducer<AmazonClientExtensionBuildItem> amazonExtensions) {
        this.setupExtension((AmazonClientRecorder)recorder, amazonExtensions);
    }
}

