/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.amazon.kms.runtime;

import io.quarkiverse.amazon.common.runtime.AmazonClientRecorder;
import io.quarkiverse.amazon.common.runtime.AsyncHttpClientConfig;
import io.quarkiverse.amazon.common.runtime.HasAmazonClientRuntimeConfig;
import io.quarkiverse.amazon.common.runtime.SyncHttpClientConfig;
import io.quarkiverse.amazon.kms.runtime.KmsConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import software.amazon.awssdk.awscore.client.builder.AwsAsyncClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import software.amazon.awssdk.services.kms.KmsAsyncClient;
import software.amazon.awssdk.services.kms.KmsClient;

@Recorder
public class KmsRecorder
extends AmazonClientRecorder {
    final KmsConfig config;

    public KmsRecorder(KmsConfig config) {
        this.config = config;
    }

    public RuntimeValue<HasAmazonClientRuntimeConfig> getAmazonClientsConfig() {
        return new RuntimeValue((Object)this.config);
    }

    public AsyncHttpClientConfig getAsyncClientConfig() {
        return this.config.asyncClient();
    }

    public SyncHttpClientConfig getSyncClientConfig() {
        return this.config.syncClient();
    }

    public AwsSyncClientBuilder<?, ?> geSyncClientBuilder() {
        return KmsClient.builder();
    }

    public AwsAsyncClientBuilder<?, ?> getAsyncClientBuilder() {
        return KmsAsyncClient.builder();
    }
}

