/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.lambda.runtime;

import io.quarkus.amazon.common.runtime.AmazonClientRecorder;
import io.quarkus.amazon.common.runtime.AsyncHttpClientConfig;
import io.quarkus.amazon.common.runtime.HasAmazonClientRuntimeConfig;
import io.quarkus.amazon.common.runtime.SyncHttpClientConfig;
import io.quarkus.amazon.lambda.runtime.LambdaConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import software.amazon.awssdk.awscore.client.builder.AwsAsyncClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import software.amazon.awssdk.services.lambda.LambdaAsyncClient;
import software.amazon.awssdk.services.lambda.LambdaClient;

@Recorder
public class LambdaRecorder
extends AmazonClientRecorder {
    final LambdaConfig config;

    public LambdaRecorder(LambdaConfig config) {
        this.config = config;
    }

    public RuntimeValue<HasAmazonClientRuntimeConfig> getAmazonClientsConfig() {
        return new RuntimeValue((Object)this.config);
    }

    public AsyncHttpClientConfig getAsyncClientConfig() {
        return this.config.asyncClient();
    }

    public SyncHttpClientConfig getSyncClientConfig() {
        return this.config.syncClient();
    }

    public AwsSyncClientBuilder<?, ?> geSyncClientBuilder() {
        return LambdaClient.builder();
    }

    public AwsAsyncClientBuilder<?, ?> getAsyncClientBuilder() {
        return LambdaAsyncClient.builder();
    }
}

