/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.amazon.lambda.runtime;

import io.quarkiverse.amazon.common.runtime.AmazonClientRecorder;
import io.quarkiverse.amazon.common.runtime.AsyncHttpClientConfig;
import io.quarkiverse.amazon.common.runtime.HasAmazonClientRuntimeConfig;
import io.quarkiverse.amazon.common.runtime.SyncHttpClientConfig;
import io.quarkiverse.amazon.lambda.runtime.LambdaConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import software.amazon.awssdk.awscore.client.builder.AwsAsyncClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import software.amazon.awssdk.services.lambda.LambdaAsyncClient;
import software.amazon.awssdk.services.lambda.LambdaAsyncClientBuilder;
import software.amazon.awssdk.services.lambda.LambdaClient;
import software.amazon.awssdk.services.lambda.LambdaClientBuilder;

@Recorder
public class LambdaRecorder
extends AmazonClientRecorder {
    final LambdaConfig config;

    public LambdaRecorder(LambdaConfig config) {
        this.config = config;
    }

    public RuntimeValue<HasAmazonClientRuntimeConfig> getAmazonClientsConfig() {
        return new RuntimeValue((Object)this.config);
    }

    public AsyncHttpClientConfig getAsyncClientConfig() {
        return this.config.asyncClient();
    }

    public SyncHttpClientConfig getSyncClientConfig() {
        return this.config.syncClient();
    }

    public AwsSyncClientBuilder<?, ?> getSyncClientBuilder() {
        LambdaClientBuilder builder = LambdaClient.builder();
        return builder;
    }

    public AwsAsyncClientBuilder<?, ?> getAsyncClientBuilder() {
        LambdaAsyncClientBuilder builder = LambdaAsyncClient.builder();
        return builder;
    }
}

