/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.s3.deployment;

import io.quarkus.amazon.common.runtime.SdkAutoCloseableDestroyer;
import io.quarkus.amazon.s3.runtime.S3Crt;
import io.quarkus.amazon.s3.runtime.S3CrtRecorder;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.runtime.RuntimeValue;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3CrtAsyncClientBuilder;

public class S3CrtProcessor {
    public static final DotName S3CRT = DotName.createSimple(S3Crt.class);
    public static final String AWS_S3_CRT = "software.amazon.awssdk.crt.s3.S3Client";

    protected String configName() {
        return "s3";
    }

    protected DotName asyncClientName() {
        return DotName.createSimple((String)S3AsyncClient.class.getName());
    }

    @BuildStep(onlyIf={IsAmazonCrtS3ClientPresent.class})
    AdditionalBeanBuildItem qualifiers() {
        return AdditionalBeanBuildItem.unremovableOf(S3Crt.class);
    }

    @BuildStep(onlyIf={IsAmazonCrtS3ClientPresent.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void createS3CrtClientBuilders(S3CrtRecorder recorder, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, BeanRegistrationPhaseBuildItem beanRegistrationPhase) {
        Optional<Object> asyncClassName = Optional.empty();
        for (InjectionPointInfo injectionPoint : beanRegistrationPhase.getInjectionPoints()) {
            if (null == injectionPoint.getRequiredQualifier(S3CRT)) continue;
            Type injectedType = this.getInjectedType(injectionPoint);
            if (!this.asyncClientName().equals((Object)injectedType.name())) continue;
            asyncClassName = Optional.of(this.asyncClientName());
        }
        if (asyncClassName.isPresent()) {
            RuntimeValue asyncClientBuilder = recorder.getCrtAsyncClientBuilder(this.configName());
            syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(S3CrtAsyncClientBuilder.class).unremovable()).setRuntimeInit().defaultBean()).scope(ApplicationScoped.class)).runtimeValue(asyncClientBuilder).done());
            syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(S3AsyncClient.class).unremovable()).setRuntimeInit().scope(ApplicationScoped.class)).addQualifier(S3Crt.class)).createWith(recorder.getS3CrtAsyncClient()).destroyer(SdkAutoCloseableDestroyer.class)).addInjectionPoint((Type)ClassType.create(S3CrtAsyncClientBuilder.class), new AnnotationInstance[0])).done());
        }
    }

    private Type getInjectedType(InjectionPointInfo injectionPoint) {
        Type requiredType;
        Type injectedType = requiredType = injectionPoint.getRequiredType();
        if (DotNames.INSTANCE.equals((Object)requiredType.name()) && requiredType instanceof ParameterizedType) {
            injectedType = (Type)requiredType.asParameterizedType().arguments().get(0);
        }
        return injectedType;
    }

    public static class IsAmazonCrtS3ClientPresent
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            try {
                Class.forName(S3CrtProcessor.AWS_S3_CRT);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

