/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.amazon.s3.deployment;

import io.quarkiverse.amazon.common.deployment.AbstractAmazonServiceProcessor;
import io.quarkiverse.amazon.common.deployment.AmazonClientAsyncResultBuildItem;
import io.quarkiverse.amazon.common.deployment.AmazonClientAsyncTransportBuildItem;
import io.quarkiverse.amazon.common.deployment.AmazonClientInterceptorsPathBuildItem;
import io.quarkiverse.amazon.common.deployment.AmazonClientSyncResultBuildItem;
import io.quarkiverse.amazon.common.deployment.AmazonClientSyncTransportBuildItem;
import io.quarkiverse.amazon.common.deployment.AmazonHttpClients;
import io.quarkiverse.amazon.common.deployment.RequireAmazonClientBuildItem;
import io.quarkiverse.amazon.common.deployment.RequireAmazonClientInjectionBuildItem;
import io.quarkiverse.amazon.common.deployment.RequireAmazonClientTransportBuilderBuildItem;
import io.quarkiverse.amazon.common.deployment.RequireAmazonTelemetryBuildItem;
import io.quarkiverse.amazon.common.deployment.spi.EventLoopGroupBuildItem;
import io.quarkiverse.amazon.common.runtime.AmazonClientApacheTransportRecorder;
import io.quarkiverse.amazon.common.runtime.AmazonClientAwsCrtTransportRecorder;
import io.quarkiverse.amazon.common.runtime.AmazonClientCommonRecorder;
import io.quarkiverse.amazon.common.runtime.AmazonClientNettyTransportRecorder;
import io.quarkiverse.amazon.common.runtime.AmazonClientOpenTelemetryRecorder;
import io.quarkiverse.amazon.common.runtime.AmazonClientRecorder;
import io.quarkiverse.amazon.common.runtime.AmazonClientUrlConnectionTransportRecorder;
import io.quarkiverse.amazon.common.runtime.HasSdkBuildTimeConfig;
import io.quarkiverse.amazon.s3.runtime.S3BuildTimeConfig;
import io.quarkiverse.amazon.s3.runtime.S3Config;
import io.quarkiverse.amazon.s3.runtime.S3Recorder;
import io.quarkus.arc.deployment.BeanRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExecutorBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import java.util.List;
import org.jboss.jandex.DotName;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.presigner.S3Presigner;

public class S3Processor
extends AbstractAmazonServiceProcessor {
    private static final String AMAZON_CLIENT_NAME = "amazon-sdk-s3";
    S3BuildTimeConfig buildTimeConfig;

    protected String amazonServiceClientName() {
        return AMAZON_CLIENT_NAME;
    }

    protected String configName() {
        return "s3";
    }

    protected DotName syncClientName() {
        return DotName.createSimple((String)S3Client.class.getName());
    }

    protected DotName asyncClientName() {
        return DotName.createSimple((String)S3AsyncClient.class.getName());
    }

    protected DotName presignerClientName() {
        return DotName.createSimple((String)S3Presigner.class.getName());
    }

    protected String builtinInterceptorsPath() {
        return "software/amazon/awssdk/services/s3/execution.interceptors";
    }

    @BuildStep
    void setup(BuildProducer<ExtensionSslNativeSupportBuildItem> extensionSslNativeSupport, BuildProducer<FeatureBuildItem> feature, BuildProducer<AmazonClientInterceptorsPathBuildItem> interceptors) {
        this.setupExtension(extensionSslNativeSupport, feature, interceptors);
    }

    @BuildStep
    void discoverClientInjectionPoints(BeanRegistrationPhaseBuildItem beanRegistrationPhase, BuildProducer<RequireAmazonClientInjectionBuildItem> requireClientInjectionProducer) {
        this.discoverClientInjectionPointsInternal(beanRegistrationPhase, requireClientInjectionProducer);
    }

    @BuildStep
    void discover(List<RequireAmazonClientInjectionBuildItem> amazonClientInjectionPoints, BuildProducer<RequireAmazonClientBuildItem> requireClientProducer) {
        this.discoverClient(amazonClientInjectionPoints, requireClientProducer);
    }

    @BuildStep
    void discoverTelemetry(BuildProducer<RequireAmazonTelemetryBuildItem> telemetryProducer) {
        this.discoverTelemetry(telemetryProducer, this.buildTimeConfig.sdk());
    }

    @BuildStep
    void setupClient(List<RequireAmazonClientBuildItem> clientRequirements, BuildProducer<RequireAmazonClientTransportBuilderBuildItem> clientProducer) {
        this.setupClient(clientRequirements, clientProducer, this.buildTimeConfig.sdk(), this.buildTimeConfig.syncClient(), this.buildTimeConfig.asyncClient());
    }

    @BuildStep(onlyIf={AmazonHttpClients.IsAmazonApacheHttpServicePresent.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setupApacheSyncTransport(List<RequireAmazonClientTransportBuilderBuildItem> amazonClients, S3Recorder recorder, AmazonClientApacheTransportRecorder transportRecorder, BuildProducer<AmazonClientSyncTransportBuildItem> syncTransports) {
        this.createApacheSyncTransportBuilder(amazonClients, transportRecorder, this.buildTimeConfig.syncClient(), recorder.getSyncConfig(), syncTransports);
    }

    @BuildStep(onlyIf={AmazonHttpClients.IsAmazonAwsCrtHttpServicePresent.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setupAwsCrtSyncTransport(List<RequireAmazonClientTransportBuilderBuildItem> amazonClients, S3Recorder recorder, AmazonClientAwsCrtTransportRecorder transportRecorder, BuildProducer<AmazonClientSyncTransportBuildItem> syncTransports) {
        this.createAwsCrtSyncTransportBuilder(amazonClients, transportRecorder, this.buildTimeConfig.syncClient(), recorder.getSyncConfig(), syncTransports);
    }

    @BuildStep(onlyIf={AmazonHttpClients.IsAmazonUrlConnectionHttpServicePresent.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setupUrlConnectionSyncTransport(List<RequireAmazonClientTransportBuilderBuildItem> amazonClients, S3Recorder recorder, AmazonClientUrlConnectionTransportRecorder transportRecorder, BuildProducer<AmazonClientSyncTransportBuildItem> syncTransports) {
        this.createUrlConnectionSyncTransportBuilder(amazonClients, transportRecorder, this.buildTimeConfig.syncClient(), recorder.getSyncConfig(), syncTransports);
    }

    @BuildStep(onlyIf={AmazonHttpClients.IsAmazonNettyHttpServicePresent.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setupNettyAsyncTransport(List<RequireAmazonClientTransportBuilderBuildItem> amazonClients, S3Recorder recorder, AmazonClientNettyTransportRecorder transportRecorder, S3Config runtimeConfig, BuildProducer<AmazonClientAsyncTransportBuildItem> asyncTransports, EventLoopGroupBuildItem eventLoopSupplier) {
        this.createNettyAsyncTransportBuilder(amazonClients, transportRecorder, this.buildTimeConfig.asyncClient(), recorder.getAsyncConfig(), asyncTransports, eventLoopSupplier.getMainEventLoopGroup());
    }

    @BuildStep(onlyIf={AmazonHttpClients.IsAmazonAwsCrtHttpServicePresent.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setupAwsCrtAsyncTransport(List<RequireAmazonClientTransportBuilderBuildItem> amazonClients, S3Recorder recorder, AmazonClientAwsCrtTransportRecorder transportRecorder, BuildProducer<AmazonClientAsyncTransportBuildItem> asyncTransports) {
        this.createAwsCrtAsyncTransportBuilder(amazonClients, transportRecorder, this.buildTimeConfig.asyncClient(), recorder.getAsyncConfig(), asyncTransports);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void createClientBuilders(S3Recorder recorder, AmazonClientCommonRecorder commonRecorder, AmazonClientOpenTelemetryRecorder otelRecorder, List<RequireAmazonClientInjectionBuildItem> amazonClientInjections, List<RequireAmazonTelemetryBuildItem> amazonRequireTelemtryClients, List<AmazonClientSyncTransportBuildItem> syncTransports, List<AmazonClientAsyncTransportBuildItem> asyncTransports, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, BuildProducer<AmazonClientSyncResultBuildItem> clientSync, BuildProducer<AmazonClientAsyncResultBuildItem> clientAsync, LaunchModeBuildItem launchModeBuildItem, ExecutorBuildItem executorBuildItem) {
        this.createClientBuilders((AmazonClientRecorder)recorder, commonRecorder, otelRecorder, (HasSdkBuildTimeConfig)this.buildTimeConfig, amazonClientInjections, amazonRequireTelemtryClients, syncTransports, asyncTransports, S3ClientBuilder.class, S3AsyncClientBuilder.class, S3Presigner.Builder.class, syntheticBeans, clientSync, clientAsync, launchModeBuildItem, executorBuildItem);
    }
}

