/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.s3.deployment;

import io.quarkus.amazon.common.deployment.AmazonClientInterceptorsPathBuildItem;
import io.quarkus.amazon.common.deployment.RequireAmazonClientBuildItem;
import io.quarkus.amazon.common.runtime.SdkAutoCloseableDestroyer;
import io.quarkus.amazon.s3.deployment.S3CrtProcessor;
import io.quarkus.amazon.s3.runtime.S3Crt;
import io.quarkus.amazon.s3.runtime.S3CrtTransferManagerRecorder;
import io.quarkus.amazon.s3.runtime.S3TransferManagerProducer;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.Optional;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.internal.crt.S3CrtAsyncClient;
import software.amazon.awssdk.transfer.s3.S3TransferManager;

public class S3TransferManagerProcessor {
    public static final DotName S3CRT_CLIENT = DotName.createSimple(S3CrtAsyncClient.class);

    @BuildStep
    void setupExtension(BuildProducer<ExtensionSslNativeSupportBuildItem> extensionSslNativeSupport, BuildProducer<FeatureBuildItem> feature, BuildProducer<AmazonClientInterceptorsPathBuildItem> interceptors) {
        feature.produce((BuildItem)new FeatureBuildItem("amazon-s3-transfer-manager"));
    }

    @BuildStep
    AdditionalBeanBuildItem producer() {
        return AdditionalBeanBuildItem.builder().addBeanClasses(new Class[]{S3TransferManagerProducer.class}).setUnremovable().build();
    }

    @BuildStep(onlyIf={S3CrtProcessor.IsAmazonCrtS3ClientPresent.class})
    void requireS3CrtClient(BuildProducer<RequireAmazonClientBuildItem> requireClientProducer) {
        requireClientProducer.produce((BuildItem)new RequireAmazonClientBuildItem(Optional.empty(), Optional.of(S3CRT_CLIENT)));
    }

    @BuildStep(onlyIf={S3CrtProcessor.IsAmazonCrtS3ClientPresent.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void createS3CrtTransferManager(S3CrtTransferManagerRecorder recorder, BuildProducer<SyntheticBeanBuildItem> syntheticBeans) {
        syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(S3TransferManager.class).unremovable()).setRuntimeInit().scope(ApplicationScoped.class)).addQualifier(S3Crt.class)).createWith(recorder.getS3CrtTransferManager()).destroyer(SdkAutoCloseableDestroyer.class)).addInjectionPoint((Type)ClassType.create(S3AsyncClient.class), new AnnotationInstance[]{AnnotationInstance.builder(S3Crt.class).build()})).done());
    }
}

