/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.s3.runtime;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import io.quarkus.amazon.s3.runtime.IsS3CrtAbsent;
import io.quarkus.amazon.s3.runtime.Target_GenericS3TransferManager;
import java.util.function.Supplier;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.transfer.s3.S3TransferManager;
import software.amazon.awssdk.transfer.s3.internal.TransferManagerConfiguration;
import software.amazon.awssdk.transfer.s3.internal.TransferManagerFactory;
import software.amazon.awssdk.utils.Logger;

@TargetClass(value=TransferManagerFactory.class, onlyWith={IsS3CrtAbsent.class})
final class Target_TransferManagerFactory {
    @Alias
    private static Logger log;

    Target_TransferManagerFactory() {
    }

    @Substitute
    public static S3TransferManager createTransferManager(TransferManagerFactory.DefaultBuilder tmBuilder) {
        boolean isDefaultS3AsyncClient;
        TransferManagerConfiguration transferConfiguration = Target_TransferManagerFactory.resolveTransferManagerConfiguration(tmBuilder);
        S3AsyncClient s3AsyncClient = ((Target_TransferManagerFactory_DefaultBuilder)tmBuilder).s3AsyncClient;
        if (s3AsyncClient == null) {
            isDefaultS3AsyncClient = true;
            s3AsyncClient = Target_TransferManagerFactory.defaultS3AsyncClient().get();
        } else {
            isDefaultS3AsyncClient = false;
        }
        return new Target_GenericS3TransferManager(transferConfiguration, s3AsyncClient, isDefaultS3AsyncClient);
    }

    @Alias
    private static TransferManagerConfiguration resolveTransferManagerConfiguration(TransferManagerFactory.DefaultBuilder tmBuilder) {
        return null;
    }

    @Substitute
    private static Supplier<S3AsyncClient> defaultS3AsyncClient() {
        return S3AsyncClient::create;
    }

    @TargetClass(value=TransferManagerFactory.DefaultBuilder.class, onlyWith={IsS3CrtAbsent.class})
    public static final class Target_TransferManagerFactory_DefaultBuilder {
        @Alias
        private S3AsyncClient s3AsyncClient;
    }
}

