/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.s3.runtime;

import io.quarkus.amazon.common.runtime.AmazonClientConfig;
import io.quarkus.amazon.common.runtime.AwsConfig;
import io.quarkus.amazon.common.runtime.RuntimeConfigurationError;
import io.quarkus.amazon.common.runtime.SdkConfig;
import io.quarkus.amazon.s3.runtime.S3Config;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.concurrent.Executor;
import java.util.function.Function;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3CrtAsyncClientBuilder;
import software.amazon.awssdk.utils.StringUtils;

@Recorder
public class S3CrtRecorder {
    final S3Config config;

    public S3CrtRecorder(S3Config config) {
        this.config = config;
    }

    public RuntimeValue<S3CrtAsyncClientBuilder> getCrtAsyncClientBuilder(String awsServiceName) {
        S3CrtAsyncClientBuilder builder = S3AsyncClient.crtBuilder();
        this.configureS3Client(builder, awsServiceName);
        return new RuntimeValue((Object)builder);
    }

    private void configureS3Client(S3CrtAsyncClientBuilder builder, String awsServiceName) {
        URI endpointOverride;
        builder.accelerate(Boolean.valueOf(this.config.accelerateMode())).checksumValidationEnabled(Boolean.valueOf(this.config.checksumValidation())).crossRegionAccessEnabled(Boolean.valueOf(this.config.useArnRegionEnabled())).forcePathStyle(Boolean.valueOf(this.config.pathStyleAccess()));
        this.config.crtClient().initialReadBufferSizeInBytes().ifPresent(arg_0 -> ((S3CrtAsyncClientBuilder)builder).initialReadBufferSizeInBytes(arg_0));
        this.config.crtClient().maxConcurrency().ifPresent(arg_0 -> ((S3CrtAsyncClientBuilder)builder).maxConcurrency(arg_0));
        this.config.crtClient().minimumPartSizeInBytes().ifPresent(arg_0 -> ((S3CrtAsyncClientBuilder)builder).minimumPartSizeInBytes(arg_0));
        this.config.crtClient().targetThroughputInGbps().ifPresent(arg_0 -> ((S3CrtAsyncClientBuilder)builder).targetThroughputInGbps(arg_0));
        this.config.crtClient().maxNativeMemoryLimitInBytes().ifPresent(arg_0 -> ((S3CrtAsyncClientBuilder)builder).maxNativeMemoryLimitInBytes(arg_0));
        AwsConfig awsConfig = ((AmazonClientConfig)this.config.clients().get("<default>")).aws();
        SdkConfig sdkConfig = ((AmazonClientConfig)this.config.clients().get("<default>")).sdk();
        awsConfig.region().ifPresent(arg_0 -> ((S3CrtAsyncClientBuilder)builder).region(arg_0));
        AwsCredentialsProvider credential = awsConfig.credentials().map(c -> c.type().create(c, "quarkus." + awsServiceName)).orElseGet(() -> DefaultCredentialsProvider.builder().asyncCredentialUpdateEnabled(Boolean.valueOf(false)).reuseLastProviderEnabled(Boolean.valueOf(false)).build());
        builder.credentialsProvider(credential);
        if (sdkConfig.endpointOverride().isPresent() && StringUtils.isBlank((CharSequence)(endpointOverride = (URI)sdkConfig.endpointOverride().get()).getScheme())) {
            throw new RuntimeConfigurationError(String.format("quarkus.%s.endpoint-override (%s) - scheme must be specified", awsServiceName, endpointOverride.toString()));
        }
        sdkConfig.endpointOverride().filter(URI::isAbsolute).ifPresent(arg_0 -> ((S3CrtAsyncClientBuilder)builder).endpointOverride(arg_0));
    }

    public RuntimeValue<S3CrtAsyncClientBuilder> setExecutor(RuntimeValue<S3CrtAsyncClientBuilder> builder, LaunchMode launchMode, Executor executor) {
        if (launchMode == LaunchMode.NORMAL) {
            return new RuntimeValue((Object)((S3CrtAsyncClientBuilder)builder.getValue()).futureCompletionExecutor(executor));
        }
        return new RuntimeValue((Object)((S3CrtAsyncClientBuilder)builder.getValue()).futureCompletionExecutor((Executor)new S3CrtExecutorWrapper(executor)));
    }

    public Function<SyntheticCreationalContext<S3AsyncClient>, S3AsyncClient> getS3CrtAsyncClient() {
        return new Function<SyntheticCreationalContext<S3AsyncClient>, S3AsyncClient>(){

            @Override
            public S3AsyncClient apply(SyntheticCreationalContext<S3AsyncClient> context) {
                return ((S3CrtAsyncClientBuilder)context.getInjectedReference(S3CrtAsyncClientBuilder.class, new Annotation[0])).build();
            }
        };
    }

    private static final class S3CrtExecutorWrapper
    implements Executor {
        private Executor executor;
        private ClassLoader contextClassLoader;

        private S3CrtExecutorWrapper(Executor executor) {
            this.executor = executor;
            this.contextClassLoader = Thread.currentThread().getContextClassLoader();
        }

        @Override
        public void execute(Runnable command) {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.contextClassLoader);
                this.executor.execute(command);
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }
}

