/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.amazon.s3.runtime;

import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.util.Arrays;
import java.util.function.BooleanSupplier;
import software.amazon.awssdk.services.s3.internal.crt.DefaultS3CrtAsyncClient;
import software.amazon.awssdk.services.s3.internal.crt.S3CrtAsyncClient;

public class S3CrtSubstitutions {
    static final String SOFTWARE_AMAZON_AWSSDK_CRT_PACKAGE = "software.amazon.awssdk.crt";
    static final String SOFTWARE_AMAZON_AWSSDK_CRT_S3_PACKAGE = "software.amazon.awssdk.crt.s3";

    @TargetClass(value=S3CrtAsyncClient.class, onlyWith={IsCrtAbsent.class})
    @Delete
    static final class Delete_S3CrtAsyncClient {
        Delete_S3CrtAsyncClient() {
        }
    }

    @TargetClass(value=DefaultS3CrtAsyncClient.class, onlyWith={IsCrtAbsent.class})
    @Delete
    static final class Delete_DefaultS3CrtAsyncClient {
        Delete_DefaultS3CrtAsyncClient() {
        }
    }

    @TargetClass(value=DefaultS3CrtAsyncClient.class, onlyWith={IsS3CrtPresent.class})
    static final class Target_DefaultS3CrtAsyncClient {
        Target_DefaultS3CrtAsyncClient() {
        }

        @Substitute
        private static void validateCrtInClassPath() {
        }
    }

    static final class IsS3CrtPresent
    implements BooleanSupplier {
        IsS3CrtPresent() {
        }

        @Override
        public boolean getAsBoolean() {
            return Arrays.asList(Package.getPackages()).stream().map(p -> p.getName()).anyMatch(p -> p.equals(S3CrtSubstitutions.SOFTWARE_AMAZON_AWSSDK_CRT_S3_PACKAGE));
        }
    }

    static final class IsCrtAbsent
    implements BooleanSupplier {
        IsCrtAbsent() {
        }

        @Override
        public boolean getAsBoolean() {
            return !Arrays.asList(Package.getPackages()).stream().map(p -> p.getName()).anyMatch(p -> p.equals(S3CrtSubstitutions.SOFTWARE_AMAZON_AWSSDK_CRT_PACKAGE));
        }
    }
}

