/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.amazon.s3.runtime;

import io.quarkiverse.amazon.common.runtime.AmazonClientRecorder;
import io.quarkiverse.amazon.common.runtime.AsyncHttpClientConfig;
import io.quarkiverse.amazon.common.runtime.SyncHttpClientConfig;
import io.quarkiverse.amazon.s3.runtime.S3Config;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import software.amazon.awssdk.awscore.client.builder.AwsAsyncClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import software.amazon.awssdk.awscore.presigner.SdkPresigner;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.services.s3.S3BaseClientBuilder;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.presigner.S3Presigner;

@Recorder
public class S3Recorder
extends AmazonClientRecorder {
    final RuntimeValue<S3Config> config;

    public S3Recorder(RuntimeValue<S3Config> config) {
        this.config = config;
    }

    public RuntimeValue<S3Config> getAmazonClientsConfig() {
        return this.config;
    }

    public AsyncHttpClientConfig getAsyncClientConfig() {
        return ((S3Config)this.config.getValue()).asyncClient();
    }

    public SyncHttpClientConfig getSyncClientConfig() {
        return ((S3Config)this.config.getValue()).syncClient();
    }

    public AwsSyncClientBuilder<?, ?> getSyncClientBuilder() {
        S3ClientBuilder builder = S3Client.builder();
        this.configureS3Client((S3BaseClientBuilder)builder);
        return builder;
    }

    public AwsAsyncClientBuilder<?, ?> getAsyncClientBuilder() {
        S3AsyncClientBuilder builder = S3AsyncClient.builder();
        this.configureS3Client((S3BaseClientBuilder)builder);
        return builder;
    }

    public RuntimeValue<SdkPresigner.Builder> createPresignerBuilder() {
        S3Presigner.Builder builder = S3Presigner.builder().serviceConfiguration((S3Configuration)this.s3ConfigurationBuilder().build()).dualstackEnabled(Boolean.valueOf(((S3Config)this.config.getValue()).dualstack()));
        return new RuntimeValue((Object)builder);
    }

    private void configureS3Client(S3BaseClientBuilder builder) {
        builder.serviceConfiguration((S3Configuration)this.s3ConfigurationBuilder().build()).dualstackEnabled(Boolean.valueOf(((S3Config)this.config.getValue()).dualstack()));
    }

    private S3Configuration.Builder s3ConfigurationBuilder() {
        S3Configuration.Builder s3ConfigBuilder = S3Configuration.builder().accelerateModeEnabled(Boolean.valueOf(((S3Config)this.config.getValue()).accelerateMode())).checksumValidationEnabled(Boolean.valueOf(((S3Config)this.config.getValue()).checksumValidation())).chunkedEncodingEnabled(Boolean.valueOf(((S3Config)this.config.getValue()).chunkedEncoding())).pathStyleAccessEnabled(Boolean.valueOf(((S3Config)this.config.getValue()).pathStyleAccess())).useArnRegionEnabled(Boolean.valueOf(((S3Config)this.config.getValue()).useArnRegionEnabled()));
        ((S3Config)this.config.getValue()).profileName().ifPresent(arg_0 -> ((S3Configuration.Builder)s3ConfigBuilder).profileName(arg_0));
        return s3ConfigBuilder;
    }
}

