/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.secretsmanager.deployment;

import io.quarkus.amazon.common.deployment.AbstractAmazonServiceProcessor;
import io.quarkus.amazon.common.deployment.AmazonClientAsyncResultBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientAsyncTransportBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientInterceptorsPathBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientSyncResultBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientSyncTransportBuildItem;
import io.quarkus.amazon.common.deployment.AmazonHttpClients;
import io.quarkus.amazon.common.deployment.RequireAmazonClientBuildItem;
import io.quarkus.amazon.common.runtime.AmazonClientApacheTransportRecorder;
import io.quarkus.amazon.common.runtime.AmazonClientNettyTransportRecorder;
import io.quarkus.amazon.common.runtime.AmazonClientRecorder;
import io.quarkus.amazon.common.runtime.AmazonClientUrlConnectionTransportRecorder;
import io.quarkus.amazon.secretsmanager.runtime.SecretsManagerBuildTimeConfig;
import io.quarkus.amazon.secretsmanager.runtime.SecretsManagerClientProducer;
import io.quarkus.amazon.secretsmanager.runtime.SecretsManagerConfig;
import io.quarkus.amazon.secretsmanager.runtime.SecretsManagerRecorder;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import java.util.List;
import org.jboss.jandex.DotName;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerAsyncClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerAsyncClientBuilder;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;

public class SecretsManagerProcessor
extends AbstractAmazonServiceProcessor {
    private static final String AMAZON_SECRETS_MANAGER = "amazon-secretsmanager";
    SecretsManagerBuildTimeConfig buildTimeConfig;

    protected String amazonServiceClientName() {
        return AMAZON_SECRETS_MANAGER;
    }

    protected String configName() {
        return "secretsmanager";
    }

    protected DotName syncClientName() {
        return DotName.createSimple((String)SecretsManagerClient.class.getName());
    }

    protected DotName asyncClientName() {
        return DotName.createSimple((String)SecretsManagerAsyncClient.class.getName());
    }

    protected String builtinInterceptorsPath() {
        return "software/amazon/awssdk/services/secretsmanager/execution.interceptors";
    }

    @BuildStep
    AdditionalBeanBuildItem producer() {
        return AdditionalBeanBuildItem.unremovableOf(SecretsManagerClientProducer.class);
    }

    @BuildStep
    void discover(BeanRegistrationPhaseBuildItem beanRegistrationPhase, BuildProducer<RequireAmazonClientBuildItem> requireClientProducer) {
        this.discoverClient(beanRegistrationPhase, requireClientProducer);
    }

    @BuildStep
    void setup(List<RequireAmazonClientBuildItem> clientRequirements, BuildProducer<ExtensionSslNativeSupportBuildItem> extensionSslNativeSupport, BuildProducer<FeatureBuildItem> feature, BuildProducer<AmazonClientInterceptorsPathBuildItem> interceptors, BuildProducer<AmazonClientBuildItem> clientProducer) {
        this.setupExtension(clientRequirements, extensionSslNativeSupport, feature, interceptors, clientProducer, this.buildTimeConfig.sdk, this.buildTimeConfig.syncClient);
    }

    @BuildStep(onlyIf={AmazonHttpClients.IsAmazonApacheHttpServicePresent.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setupApacheSyncTransport(List<AmazonClientBuildItem> amazonClients, SecretsManagerRecorder recorder, AmazonClientApacheTransportRecorder transportRecorder, SecretsManagerConfig runtimeConfig, BuildProducer<AmazonClientSyncTransportBuildItem> syncTransports) {
        this.createApacheSyncTransportBuilder(amazonClients, transportRecorder, this.buildTimeConfig.syncClient, recorder.getSyncConfig(runtimeConfig), syncTransports);
    }

    @BuildStep(onlyIf={AmazonHttpClients.IsAmazonUrlConnectionHttpServicePresent.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setupUrlConnectionSyncTransport(List<AmazonClientBuildItem> amazonClients, SecretsManagerRecorder recorder, AmazonClientUrlConnectionTransportRecorder transportRecorder, SecretsManagerConfig runtimeConfig, BuildProducer<AmazonClientSyncTransportBuildItem> syncTransports) {
        this.createUrlConnectionSyncTransportBuilder(amazonClients, transportRecorder, this.buildTimeConfig.syncClient, recorder.getSyncConfig(runtimeConfig), syncTransports);
    }

    @BuildStep(onlyIf={AmazonHttpClients.IsAmazonNettyHttpServicePresent.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setupNettyAsyncTransport(List<AmazonClientBuildItem> amazonClients, SecretsManagerRecorder recorder, AmazonClientNettyTransportRecorder transportRecorder, SecretsManagerConfig runtimeConfig, BuildProducer<AmazonClientAsyncTransportBuildItem> asyncTransports) {
        this.createNettyAsyncTransportBuilder(amazonClients, transportRecorder, recorder.getAsyncConfig(runtimeConfig), asyncTransports);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void createClientBuilders(SecretsManagerRecorder recorder, AmazonClientRecorder commonRecorder, SecretsManagerConfig runtimeConfig, List<AmazonClientSyncTransportBuildItem> syncTransports, List<AmazonClientAsyncTransportBuildItem> asyncTransports, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, BuildProducer<AmazonClientSyncResultBuildItem> clientSync, BuildProducer<AmazonClientAsyncResultBuildItem> clientAsync) {
        this.createClientBuilders(commonRecorder, recorder.getAwsConfig(runtimeConfig), recorder.getSdkConfig(runtimeConfig), this.buildTimeConfig.sdk, syncTransports, asyncTransports, SecretsManagerClientBuilder.class, syncTransport -> recorder.createSyncBuilder(runtimeConfig, syncTransport), SecretsManagerAsyncClientBuilder.class, asyncTransport -> recorder.createAsyncBuilder(runtimeConfig, asyncTransport), null, null, syntheticBeans, clientSync, clientAsync);
    }
}

