/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.secretsmanager.runtime;

import io.quarkus.amazon.common.runtime.AmazonClientRecorder;
import io.quarkus.amazon.common.runtime.AsyncHttpClientConfig;
import io.quarkus.amazon.common.runtime.AwsConfig;
import io.quarkus.amazon.common.runtime.SdkConfig;
import io.quarkus.amazon.common.runtime.SyncHttpClientConfig;
import io.quarkus.amazon.secretsmanager.runtime.SecretsManagerConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import software.amazon.awssdk.awscore.client.builder.AwsAsyncClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerAsyncClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;

@Recorder
public class SecretsManagerRecorder
extends AmazonClientRecorder {
    final SecretsManagerConfig config;

    public SecretsManagerRecorder(SecretsManagerConfig config) {
        this.config = config;
    }

    public RuntimeValue<AwsConfig> getAwsConfig() {
        return new RuntimeValue((Object)this.config.aws());
    }

    public RuntimeValue<SdkConfig> getSdkConfig() {
        return new RuntimeValue((Object)this.config.sdk());
    }

    public AsyncHttpClientConfig getAsyncClientConfig() {
        return this.config.asyncClient();
    }

    public SyncHttpClientConfig getSyncClientConfig() {
        return this.config.syncClient();
    }

    public AwsSyncClientBuilder<?, ?> geSyncClientBuilder() {
        return SecretsManagerClient.builder();
    }

    public AwsAsyncClientBuilder<?, ?> getAsyncClientBuilder() {
        return SecretsManagerAsyncClient.builder();
    }
}

