/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.sns.runtime;

import io.quarkus.arc.DefaultBean;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import software.amazon.awssdk.services.sns.SnsAsyncClient;
import software.amazon.awssdk.services.sns.SnsAsyncClientBuilder;
import software.amazon.awssdk.services.sns.SnsClient;
import software.amazon.awssdk.services.sns.SnsClientBuilder;

@ApplicationScoped
public class SnsClientProducer {
    private final SnsClient syncClient;
    private final SnsAsyncClient asyncClient;

    SnsClientProducer(Instance<SnsClientBuilder> syncClientBuilderInstance, Instance<SnsAsyncClientBuilder> asyncClientBuilderInstance) {
        this.syncClient = syncClientBuilderInstance.isResolvable() ? (SnsClient)((SnsClientBuilder)syncClientBuilderInstance.get()).build() : null;
        this.asyncClient = asyncClientBuilderInstance.isResolvable() ? (SnsAsyncClient)((SnsAsyncClientBuilder)asyncClientBuilderInstance.get()).build() : null;
    }

    @DefaultBean
    @Produces
    @ApplicationScoped
    public SnsClient client() {
        if (this.syncClient == null) {
            throw new IllegalStateException("The SnsClient is required but has not been detected/configured.");
        }
        return this.syncClient;
    }

    @DefaultBean
    @Produces
    @ApplicationScoped
    public SnsAsyncClient asyncClient() {
        if (this.asyncClient == null) {
            throw new IllegalStateException("The SnsAsyncClient is required but has not been detected/configured.");
        }
        return this.asyncClient;
    }

    @PreDestroy
    public void destroy() {
        if (this.syncClient != null) {
            this.syncClient.close();
        }
        if (this.asyncClient != null) {
            this.asyncClient.close();
        }
    }
}

