/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.sqs.deployment;

import io.quarkus.amazon.common.deployment.AbstractAmazonServiceProcessor;
import io.quarkus.amazon.common.deployment.AmazonClientAsyncTransportBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientInterceptorsPathBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientSyncTransportBuildItem;
import io.quarkus.amazon.common.deployment.AmazonHttpClients;
import io.quarkus.amazon.common.runtime.AmazonClientApacheTransportRecorder;
import io.quarkus.amazon.common.runtime.AmazonClientNettyTransportRecorder;
import io.quarkus.amazon.common.runtime.AmazonClientRecorder;
import io.quarkus.amazon.common.runtime.AmazonClientUrlConnectionTransportRecorder;
import io.quarkus.amazon.sqs.runtime.SqsBuildTimeConfig;
import io.quarkus.amazon.sqs.runtime.SqsClientProducer;
import io.quarkus.amazon.sqs.runtime.SqsRecorder;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import java.util.List;
import org.jboss.jandex.DotName;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.SqsAsyncClientBuilder;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.SqsClientBuilder;

public class SqsProcessor
extends AbstractAmazonServiceProcessor {
    private static final String AMAZON_SQS = "amazon-sqs";
    SqsBuildTimeConfig buildTimeConfig;

    protected String amazonServiceClientName() {
        return AMAZON_SQS;
    }

    protected String configName() {
        return "sqs";
    }

    protected DotName syncClientName() {
        return DotName.createSimple((String)SqsClient.class.getName());
    }

    protected DotName asyncClientName() {
        return DotName.createSimple((String)SqsAsyncClient.class.getName());
    }

    protected String builtinInterceptorsPath() {
        return "software/amazon/awssdk/services/sqs/execution.interceptors";
    }

    @BuildStep
    AdditionalBeanBuildItem producer() {
        return AdditionalBeanBuildItem.unremovableOf(SqsClientProducer.class);
    }

    @BuildStep
    void setup(BeanRegistrationPhaseBuildItem beanRegistrationPhase, BuildProducer<ExtensionSslNativeSupportBuildItem> extensionSslNativeSupport, BuildProducer<FeatureBuildItem> feature, BuildProducer<AmazonClientInterceptorsPathBuildItem> interceptors, BuildProducer<AmazonClientBuildItem> clientProducer) {
        this.setupExtension(beanRegistrationPhase, extensionSslNativeSupport, feature, interceptors, clientProducer, this.buildTimeConfig.sdk, this.buildTimeConfig.syncClient);
    }

    @BuildStep(onlyIf={AmazonHttpClients.IsAmazonApacheHttpServicePresent.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setupApacheSyncTransport(List<AmazonClientBuildItem> amazonClients, SqsRecorder recorder, AmazonClientApacheTransportRecorder transportRecorder, BuildProducer<AmazonClientSyncTransportBuildItem> syncTransports) {
        this.createApacheSyncTransportBuilder(amazonClients, transportRecorder, this.buildTimeConfig.syncClient, recorder.getSyncConfig(), syncTransports);
    }

    @BuildStep(onlyIf={AmazonHttpClients.IsAmazonUrlConnectionHttpServicePresent.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setupUrlConnectionSyncTransport(List<AmazonClientBuildItem> amazonClients, SqsRecorder recorder, AmazonClientUrlConnectionTransportRecorder transportRecorder, BuildProducer<AmazonClientSyncTransportBuildItem> syncTransports) {
        this.createUrlConnectionSyncTransportBuilder(amazonClients, transportRecorder, this.buildTimeConfig.syncClient, recorder.getSyncConfig(), syncTransports);
    }

    @BuildStep(onlyIf={AmazonHttpClients.IsAmazonNettyHttpServicePresent.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setupNettyAsyncTransport(List<AmazonClientBuildItem> amazonClients, SqsRecorder recorder, AmazonClientNettyTransportRecorder transportRecorder, BuildProducer<AmazonClientAsyncTransportBuildItem> asyncTransports) {
        this.createNettyAsyncTransportBuilder(amazonClients, transportRecorder, recorder.getAsyncConfig(), asyncTransports);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void createClientBuilders(SqsRecorder recorder, AmazonClientRecorder commonRecorder, List<AmazonClientSyncTransportBuildItem> syncTransports, List<AmazonClientAsyncTransportBuildItem> asyncTransports, BuildProducer<SyntheticBeanBuildItem> syntheticBeans) {
        this.createClientBuilders(commonRecorder, recorder.getAwsConfig(), recorder.getSdkConfig(), this.buildTimeConfig.sdk, syncTransports, asyncTransports, SqsClientBuilder.class, syncTransport -> recorder.createSyncBuilder(syncTransport), SqsAsyncClientBuilder.class, asyncTransport -> recorder.createAsyncBuilder(asyncTransport), syntheticBeans);
    }
}

