/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.amazon.sqs.deployment;

import io.opentelemetry.instrumentation.awssdk.v2_2.AwsSdkTelemetry;
import io.quarkiverse.amazon.common.deployment.AmazonClientBuilderBuildItem;
import io.quarkiverse.amazon.common.deployment.AmazonClientBuilderOverrideBuildItem;
import io.quarkiverse.amazon.common.deployment.ClientDeploymentUtil;
import io.quarkiverse.amazon.common.deployment.RequireAmazonTelemetryBuildItem;
import io.quarkiverse.amazon.sqs.runtime.SqsOpenTelemetryRecorder;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.List;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.Type;
import software.amazon.awssdk.services.sqs.SqsAsyncClientBuilder;
import software.amazon.awssdk.services.sqs.SqsClientBuilder;

public class SqsOtelProcessor {
    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void wrapClientBuilders(List<AmazonClientBuilderBuildItem> clientBuilders, List<RequireAmazonTelemetryBuildItem> amazonRequireTelemtryClients, SqsOpenTelemetryRecorder otelRecorder, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, BuildProducer<AmazonClientBuilderOverrideBuildItem> overrides) {
        boolean addOpenTelemetry = amazonRequireTelemtryClients.stream().anyMatch(c -> "sqs".equals(c.getConfigName()));
        if (!addOpenTelemetry) {
            return;
        }
        for (AmazonClientBuilderBuildItem clientBuilder : clientBuilders) {
            if (clientBuilder.getBuilderClass().equals(SqsClientBuilder.class)) {
                syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)ClientDeploymentUtil.namedBuilder((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((Class)clientBuilder.getBuilderClass()), (String)clientBuilder.getClientName()).unremovable()).defaultBean()).setRuntimeInit().scope(ApplicationScoped.class)).createWith(otelRecorder.configureSync(clientBuilder.getClientBuilder())).addInjectionPoint((Type)ClassType.create(AwsSdkTelemetry.class), new AnnotationInstance[0])).done());
                overrides.produce((BuildItem)new AmazonClientBuilderOverrideBuildItem(clientBuilder.getBuilderClass(), clientBuilder.getClientName()));
                continue;
            }
            if (!clientBuilder.getBuilderClass().equals(SqsAsyncClientBuilder.class)) continue;
            syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)ClientDeploymentUtil.namedBuilder((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure((Class)clientBuilder.getBuilderClass()), (String)clientBuilder.getClientName()).unremovable()).defaultBean()).setRuntimeInit().scope(ApplicationScoped.class)).createWith(otelRecorder.configureAsync(clientBuilder.getClientBuilder())).addInjectionPoint((Type)ClassType.create(AwsSdkTelemetry.class), new AnnotationInstance[0])).done());
            overrides.produce((BuildItem)new AmazonClientBuilderOverrideBuildItem(clientBuilder.getBuilderClass(), clientBuilder.getClientName()));
        }
    }
}

