/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.amazon.sqs.deployment;

import io.quarkiverse.amazon.common.deployment.AbstractAmazonServiceProcessor;
import io.quarkiverse.amazon.common.deployment.AmazonClientExtensionBuildItem;
import io.quarkiverse.amazon.common.deployment.AmazonClientExtensionBuilderInstanceBuildItem;
import io.quarkiverse.amazon.common.deployment.RequireAmazonClientInjectionBuildItem;
import io.quarkiverse.amazon.common.runtime.AmazonClientRecorder;
import io.quarkiverse.amazon.common.runtime.HasSdkBuildTimeConfig;
import io.quarkiverse.amazon.common.runtime.HasTransportBuildTimeConfig;
import io.quarkiverse.amazon.sqs.runtime.SqsBuildTimeConfig;
import io.quarkiverse.amazon.sqs.runtime.SqsRecorder;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import java.util.List;
import org.jboss.jandex.DotName;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.SqsAsyncClientBuilder;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.SqsClientBuilder;

public class SqsProcessor
extends AbstractAmazonServiceProcessor {
    private static final String AMAZON_CLIENT_NAME = "amazon-sdk-sqs";
    SqsBuildTimeConfig buildTimeConfig;

    protected String amazonServiceClientName() {
        return AMAZON_CLIENT_NAME;
    }

    protected String configName() {
        return "sqs";
    }

    protected DotName syncClientName() {
        return DotName.createSimple((String)SqsClient.class.getName());
    }

    protected Class<?> syncClientBuilderClass() {
        return SqsClientBuilder.class;
    }

    protected DotName asyncClientName() {
        return DotName.createSimple((String)SqsAsyncClient.class.getName());
    }

    protected Class<?> asyncClientBuilderClass() {
        return SqsAsyncClientBuilder.class;
    }

    protected String builtinInterceptorsPath() {
        return "software/amazon/awssdk/services/sqs/execution.interceptors";
    }

    protected HasTransportBuildTimeConfig transportBuildTimeConfig() {
        return this.buildTimeConfig;
    }

    protected HasSdkBuildTimeConfig sdkBuildTimeConfig() {
        return this.buildTimeConfig;
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void createBuilders(SqsRecorder recorder, List<RequireAmazonClientInjectionBuildItem> amazonClientInjections, BuildProducer<AmazonClientExtensionBuilderInstanceBuildItem> builderIstances) {
        this.createExtensionBuilders((AmazonClientRecorder)recorder, amazonClientInjections, builderIstances);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setup(SqsRecorder recorder, BuildProducer<AmazonClientExtensionBuildItem> amazonExtensions) {
        this.setupExtension((AmazonClientRecorder)recorder, amazonExtensions);
    }
}

