/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.sqs.runtime;

import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.SqsAsyncClientBuilder;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.SqsClientBuilder;

@ApplicationScoped
public class SqsClientProducer {
    private final SqsClient syncClient;
    private final SqsAsyncClient asyncClient;

    SqsClientProducer(Instance<SqsClientBuilder> syncClientBuilderInstance, Instance<SqsAsyncClientBuilder> asyncClientBuilderInstance) {
        this.syncClient = syncClientBuilderInstance.isResolvable() ? (SqsClient)((SqsClientBuilder)syncClientBuilderInstance.get()).build() : null;
        this.asyncClient = asyncClientBuilderInstance.isResolvable() ? (SqsAsyncClient)((SqsAsyncClientBuilder)asyncClientBuilderInstance.get()).build() : null;
    }

    @Produces
    @ApplicationScoped
    public SqsClient client() {
        if (this.syncClient == null) {
            throw new IllegalStateException("The SqsClient is required but has not been detected/configured.");
        }
        return this.syncClient;
    }

    @Produces
    @ApplicationScoped
    public SqsAsyncClient asyncClient() {
        if (this.asyncClient == null) {
            throw new IllegalStateException("The SqsAsyncClient is required but has not been detected/configured.");
        }
        return this.asyncClient;
    }

    @PreDestroy
    public void destroy() {
        if (this.syncClient != null) {
            this.syncClient.close();
        }
        if (this.asyncClient != null) {
            this.asyncClient.close();
        }
    }
}

