/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.ssm.runtime;

import io.quarkus.amazon.common.runtime.AmazonClientRecorder;
import io.quarkus.amazon.common.runtime.AsyncHttpClientConfig;
import io.quarkus.amazon.common.runtime.AwsConfig;
import io.quarkus.amazon.common.runtime.SdkConfig;
import io.quarkus.amazon.common.runtime.SyncHttpClientConfig;
import io.quarkus.amazon.ssm.runtime.SsmConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import software.amazon.awssdk.awscore.client.builder.AwsAsyncClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.SsmClient;

@Recorder
public class SsmRecorder
extends AmazonClientRecorder {
    final SsmConfig config;

    public SsmRecorder(SsmConfig config) {
        this.config = config;
    }

    public RuntimeValue<AwsConfig> getAwsConfig() {
        return new RuntimeValue((Object)this.config.aws());
    }

    public RuntimeValue<SdkConfig> getSdkConfig() {
        return new RuntimeValue((Object)this.config.sdk());
    }

    public AsyncHttpClientConfig getAsyncClientConfig() {
        return this.config.asyncClient();
    }

    public SyncHttpClientConfig getSyncClientConfig() {
        return this.config.syncClient();
    }

    public AwsSyncClientBuilder<?, ?> geSyncClientBuilder() {
        return SsmClient.builder();
    }

    public AwsAsyncClientBuilder<?, ?> getAsyncClientBuilder() {
        return SsmAsyncClient.builder();
    }
}

