/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.ssm.runtime;

import io.quarkus.arc.DefaultBean;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.SsmAsyncClientBuilder;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.SsmClientBuilder;

@ApplicationScoped
public class SsmClientProducer {
    private final SsmClient syncClient;
    private final SsmAsyncClient asyncClient;

    SsmClientProducer(Instance<SsmClientBuilder> syncClientBuilderInstance, Instance<SsmAsyncClientBuilder> asyncClientBuilderInstance) {
        this.syncClient = syncClientBuilderInstance.isResolvable() ? (SsmClient)((SsmClientBuilder)syncClientBuilderInstance.get()).build() : null;
        this.asyncClient = asyncClientBuilderInstance.isResolvable() ? (SsmAsyncClient)((SsmAsyncClientBuilder)asyncClientBuilderInstance.get()).build() : null;
    }

    @DefaultBean
    @Produces
    @ApplicationScoped
    public SsmClient client() {
        if (this.syncClient == null) {
            throw new IllegalStateException("The SsmClient is required but has not been detected/configured.");
        }
        return this.syncClient;
    }

    @DefaultBean
    @Produces
    @ApplicationScoped
    public SsmAsyncClient asyncClient() {
        if (this.asyncClient == null) {
            throw new IllegalStateException("The SsmAsyncClient is required but has not been detected/configured.");
        }
        return this.asyncClient;
    }

    @PreDestroy
    public void destroy() {
        if (this.syncClient != null) {
            this.syncClient.close();
        }
        if (this.asyncClient != null) {
            this.asyncClient.close();
        }
    }
}

