/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.sts.deployment;

import io.quarkus.amazon.common.deployment.AbstractAmazonServiceProcessor;
import io.quarkus.amazon.common.deployment.AmazonClientAsyncResultBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientAsyncTransportBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientInterceptorsPathBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientSyncResultBuildItem;
import io.quarkus.amazon.common.deployment.AmazonClientSyncTransportBuildItem;
import io.quarkus.amazon.common.deployment.AmazonHttpClients;
import io.quarkus.amazon.common.deployment.RequireAmazonClientBuildItem;
import io.quarkus.amazon.common.deployment.RequireAmazonClientInjectionBuildItem;
import io.quarkus.amazon.common.deployment.RequireAmazonClientTransportBuilderBuildItem;
import io.quarkus.amazon.common.deployment.RequireAmazonTelemetryBuildItem;
import io.quarkus.amazon.common.deployment.spi.EventLoopGroupBuildItem;
import io.quarkus.amazon.common.runtime.AmazonClientApacheTransportRecorder;
import io.quarkus.amazon.common.runtime.AmazonClientAwsCrtTransportRecorder;
import io.quarkus.amazon.common.runtime.AmazonClientCommonRecorder;
import io.quarkus.amazon.common.runtime.AmazonClientNettyTransportRecorder;
import io.quarkus.amazon.common.runtime.AmazonClientOpenTelemetryRecorder;
import io.quarkus.amazon.common.runtime.AmazonClientRecorder;
import io.quarkus.amazon.common.runtime.AmazonClientUrlConnectionTransportRecorder;
import io.quarkus.amazon.common.runtime.HasSdkBuildTimeConfig;
import io.quarkus.amazon.sts.runtime.StsBuildTimeConfig;
import io.quarkus.amazon.sts.runtime.StsRecorder;
import io.quarkus.arc.deployment.BeanRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExecutorBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import java.util.List;
import org.jboss.jandex.DotName;
import software.amazon.awssdk.services.sts.StsAsyncClient;
import software.amazon.awssdk.services.sts.StsAsyncClientBuilder;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;

public class StsProcessor
extends AbstractAmazonServiceProcessor {
    private static final String AMAZON_CLIENT_NAME = "amazon-sts";
    StsBuildTimeConfig buildTimeConfig;

    protected String amazonServiceClientName() {
        return AMAZON_CLIENT_NAME;
    }

    protected String configName() {
        return "sts";
    }

    protected DotName syncClientName() {
        return DotName.createSimple((String)StsClient.class.getName());
    }

    protected DotName asyncClientName() {
        return DotName.createSimple((String)StsAsyncClient.class.getName());
    }

    protected String builtinInterceptorsPath() {
        return "software/amazon/awssdk/services/sts/execution.interceptors";
    }

    @BuildStep
    void setup(BuildProducer<ExtensionSslNativeSupportBuildItem> extensionSslNativeSupport, BuildProducer<FeatureBuildItem> feature, BuildProducer<AmazonClientInterceptorsPathBuildItem> interceptors) {
        this.setupExtension(extensionSslNativeSupport, feature, interceptors);
    }

    @BuildStep
    void discoverClientInjectionPoints(BeanRegistrationPhaseBuildItem beanRegistrationPhase, BuildProducer<RequireAmazonClientInjectionBuildItem> requireClientInjectionProducer) {
        this.discoverClientInjectionPointsInternal(beanRegistrationPhase, requireClientInjectionProducer);
    }

    @BuildStep
    void discover(List<RequireAmazonClientInjectionBuildItem> amazonClientInjectionPoints, BuildProducer<RequireAmazonClientBuildItem> requireClientProducer) {
        this.discoverClient(amazonClientInjectionPoints, requireClientProducer);
    }

    @BuildStep
    void discoverTelemetry(BuildProducer<RequireAmazonTelemetryBuildItem> telemetryProducer) {
        this.discoverTelemetry(telemetryProducer, this.buildTimeConfig.sdk());
    }

    @BuildStep
    void setupClient(List<RequireAmazonClientBuildItem> clientRequirements, BuildProducer<RequireAmazonClientTransportBuilderBuildItem> clientProducer) {
        this.setupClient(clientRequirements, clientProducer, this.buildTimeConfig.sdk(), this.buildTimeConfig.syncClient(), this.buildTimeConfig.asyncClient());
    }

    @BuildStep(onlyIf={AmazonHttpClients.IsAmazonApacheHttpServicePresent.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setupApacheSyncTransport(List<RequireAmazonClientTransportBuilderBuildItem> amazonClients, StsRecorder recorder, AmazonClientApacheTransportRecorder transportRecorder, BuildProducer<AmazonClientSyncTransportBuildItem> syncTransports) {
        this.createApacheSyncTransportBuilder(amazonClients, transportRecorder, this.buildTimeConfig.syncClient(), recorder.getSyncConfig(), syncTransports);
    }

    @BuildStep(onlyIf={AmazonHttpClients.IsAmazonAwsCrtHttpServicePresent.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setupAwsCrtSyncTransport(List<RequireAmazonClientTransportBuilderBuildItem> amazonClients, StsRecorder recorder, AmazonClientAwsCrtTransportRecorder transportRecorder, BuildProducer<AmazonClientSyncTransportBuildItem> syncTransports) {
        this.createAwsCrtSyncTransportBuilder(amazonClients, transportRecorder, this.buildTimeConfig.syncClient(), recorder.getSyncConfig(), syncTransports);
    }

    @BuildStep(onlyIf={AmazonHttpClients.IsAmazonUrlConnectionHttpServicePresent.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setupUrlConnectionSyncTransport(List<RequireAmazonClientTransportBuilderBuildItem> amazonClients, StsRecorder recorder, AmazonClientUrlConnectionTransportRecorder transportRecorder, BuildProducer<AmazonClientSyncTransportBuildItem> syncTransports) {
        this.createUrlConnectionSyncTransportBuilder(amazonClients, transportRecorder, this.buildTimeConfig.syncClient(), recorder.getSyncConfig(), syncTransports);
    }

    @BuildStep(onlyIf={AmazonHttpClients.IsAmazonNettyHttpServicePresent.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setupNettyAsyncTransport(List<RequireAmazonClientTransportBuilderBuildItem> amazonClients, StsRecorder recorder, AmazonClientNettyTransportRecorder transportRecorder, BuildProducer<AmazonClientAsyncTransportBuildItem> asyncTransports, EventLoopGroupBuildItem eventLoopSupplier) {
        this.createNettyAsyncTransportBuilder(amazonClients, transportRecorder, this.buildTimeConfig.asyncClient(), recorder.getAsyncConfig(), asyncTransports, eventLoopSupplier.getMainEventLoopGroup());
    }

    @BuildStep(onlyIf={AmazonHttpClients.IsAmazonAwsCrtHttpServicePresent.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setupAwsCrtAsyncTransport(List<RequireAmazonClientTransportBuilderBuildItem> amazonClients, StsRecorder recorder, AmazonClientAwsCrtTransportRecorder transportRecorder, BuildProducer<AmazonClientAsyncTransportBuildItem> asyncTransports) {
        this.createAwsCrtAsyncTransportBuilder(amazonClients, transportRecorder, this.buildTimeConfig.asyncClient(), recorder.getAsyncConfig(), asyncTransports);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void createClientBuilders(StsRecorder recorder, AmazonClientCommonRecorder commonRecorder, AmazonClientOpenTelemetryRecorder otelRecorder, List<RequireAmazonClientInjectionBuildItem> amazonClientInjections, List<RequireAmazonTelemetryBuildItem> amazonRequireTelemtryClients, List<AmazonClientSyncTransportBuildItem> syncTransports, List<AmazonClientAsyncTransportBuildItem> asyncTransports, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, BuildProducer<AmazonClientSyncResultBuildItem> clientSync, BuildProducer<AmazonClientAsyncResultBuildItem> clientAsync, LaunchModeBuildItem launchModeBuildItem, ExecutorBuildItem executorBuildItem) {
        this.createClientBuilders((AmazonClientRecorder)recorder, commonRecorder, otelRecorder, (HasSdkBuildTimeConfig)this.buildTimeConfig, amazonClientInjections, amazonRequireTelemtryClients, syncTransports, asyncTransports, StsClientBuilder.class, StsAsyncClientBuilder.class, null, syntheticBeans, clientSync, clientAsync, launchModeBuildItem, executorBuildItem);
    }
}

