/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.amazon.sts.deployment;

import io.quarkiverse.amazon.common.deployment.AbstractAmazonServiceProcessor;
import io.quarkiverse.amazon.common.deployment.AmazonClientExtensionBuildItem;
import io.quarkiverse.amazon.common.deployment.AmazonClientExtensionBuilderInstanceBuildItem;
import io.quarkiverse.amazon.common.deployment.RequireAmazonClientInjectionBuildItem;
import io.quarkiverse.amazon.common.runtime.AmazonClientRecorder;
import io.quarkiverse.amazon.common.runtime.HasSdkBuildTimeConfig;
import io.quarkiverse.amazon.common.runtime.HasTransportBuildTimeConfig;
import io.quarkiverse.amazon.sts.runtime.StsBuildTimeConfig;
import io.quarkiverse.amazon.sts.runtime.StsRecorder;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import java.util.List;
import org.jboss.jandex.DotName;
import software.amazon.awssdk.services.sts.StsAsyncClient;
import software.amazon.awssdk.services.sts.StsAsyncClientBuilder;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;

public class StsProcessor
extends AbstractAmazonServiceProcessor {
    private static final String AMAZON_CLIENT_NAME = "amazon-sdk-sts";
    StsBuildTimeConfig buildTimeConfig;

    protected String amazonServiceClientName() {
        return AMAZON_CLIENT_NAME;
    }

    protected String configName() {
        return "sts";
    }

    protected DotName syncClientName() {
        return DotName.createSimple((String)StsClient.class.getName());
    }

    protected Class<?> syncClientBuilderClass() {
        return StsClientBuilder.class;
    }

    protected DotName asyncClientName() {
        return DotName.createSimple((String)StsAsyncClient.class.getName());
    }

    protected Class<?> asyncClientBuilderClass() {
        return StsAsyncClientBuilder.class;
    }

    protected String builtinInterceptorsPath() {
        return "software/amazon/awssdk/services/sts/execution.interceptors";
    }

    protected HasTransportBuildTimeConfig transportBuildTimeConfig() {
        return this.buildTimeConfig;
    }

    protected HasSdkBuildTimeConfig sdkBuildTimeConfig() {
        return this.buildTimeConfig;
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void createBuilders(StsRecorder recorder, List<RequireAmazonClientInjectionBuildItem> amazonClientInjections, BuildProducer<AmazonClientExtensionBuilderInstanceBuildItem> builderInstances) {
        this.createExtensionBuilders((AmazonClientRecorder)recorder, amazonClientInjections, builderInstances);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void setup(StsRecorder recorder, BuildProducer<AmazonClientExtensionBuildItem> amazonExtensions) {
        this.setupExtension((AmazonClientRecorder)recorder, amazonExtensions);
    }
}

