/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.sts.runtime;

import io.quarkus.amazon.common.runtime.AmazonClientRecorder;
import io.quarkus.amazon.common.runtime.AsyncHttpClientConfig;
import io.quarkus.amazon.common.runtime.HasAmazonClientRuntimeConfig;
import io.quarkus.amazon.common.runtime.SyncHttpClientConfig;
import io.quarkus.amazon.sts.runtime.StsConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import software.amazon.awssdk.awscore.client.builder.AwsAsyncClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import software.amazon.awssdk.services.sts.StsAsyncClient;
import software.amazon.awssdk.services.sts.StsClient;

@Recorder
public class StsRecorder
extends AmazonClientRecorder {
    final StsConfig config;

    public StsRecorder(StsConfig config) {
        this.config = config;
    }

    public RuntimeValue<HasAmazonClientRuntimeConfig> getAmazonClientsConfig() {
        return new RuntimeValue((Object)this.config);
    }

    public AsyncHttpClientConfig getAsyncClientConfig() {
        return this.config.asyncClient();
    }

    public SyncHttpClientConfig getSyncClientConfig() {
        return this.config.syncClient();
    }

    public AwsSyncClientBuilder<?, ?> geSyncClientBuilder() {
        return StsClient.builder();
    }

    public AwsAsyncClientBuilder<?, ?> getAsyncClientBuilder() {
        return StsAsyncClient.builder();
    }
}

