/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.argocd.deployment;

import io.dekorate.utils.Git;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.quarkiverse.argocd.deployment.ArgoCDConfiguration;
import io.quarkiverse.argocd.deployment.ScmInfoBuildItem;
import io.quarkiverse.argocd.deployment.utils.Serialization;
import io.quarkiverse.argocd.spi.ArgoCDOutputDirBuildItem;
import io.quarkiverse.argocd.spi.ArgoCDResourceListBuildItem;
import io.quarkiverse.argocd.v1alpha1.AppProject;
import io.quarkiverse.argocd.v1alpha1.AppProjectBuilder;
import io.quarkiverse.argocd.v1alpha1.AppProjectFluent;
import io.quarkiverse.argocd.v1alpha1.AppProjectSpecFluent;
import io.quarkiverse.argocd.v1alpha1.Application;
import io.quarkiverse.argocd.v1alpha1.ApplicationBuilder;
import io.quarkiverse.argocd.v1alpha1.ApplicationFluent;
import io.quarkiverse.argocd.v1alpha1.ApplicationSpecFluent;
import io.quarkiverse.argocd.v1alpha1.ArgoCDResourceList;
import io.quarkiverse.argocd.v1alpha1.applicationspec.SourceFluent;
import io.quarkiverse.argocd.v1alpha1.applicationspec.SyncPolicyFluent;
import io.quarkiverse.argocd.v1alpha1.applicationspec.syncpolicy.RetryFluent;
import io.quarkiverse.helm.spi.CustomHelmOutputDirBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsTest;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedFileSystemResourceBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.kubernetes.spi.KubernetesDeploymentTargetBuildItem;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import org.jboss.logging.Logger;

class ArgoCDProcessor {
    private static final String FEATURE = "argocd";
    private static final String DOT_GIT = ".git";
    private static final Logger log = Logger.getLogger(ArgoCDProcessor.class);
    private static final String ARGOCD_NAMESPACE_KUBE = "argocd";
    private static final String ARGOCD_NAMESPACE_OPERNSHIFT = "openshift-gitops";

    ArgoCDProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem("argocd");
    }

    @BuildStep
    public void populateScmInfo(OutputTargetBuildItem outputTarget, BuildProducer<ScmInfoBuildItem> scmInfoProducer) {
        Optional<Path> scmRoot = ArgoCDProcessor.getScmRoot(outputTarget);
        Optional scmInfo = scmRoot.flatMap(ScmInfoBuildItem::fromPath);
        scmInfo.filter(s -> !s.getRemote().isEmpty()).ifPresent(s -> scmInfoProducer.produce((BuildItem)s));
    }

    @BuildStep
    public void customOutputDir(OutputTargetBuildItem outputTarget, BuildProducer<ArgoCDOutputDirBuildItem.Effective> outputDirProducer) {
        ArgoCDProcessor.getScmRoot(outputTarget).ifPresentOrElse(p -> outputDirProducer.produce((BuildItem)new ArgoCDOutputDirBuildItem.Effective(p.resolve(".argocd"))), () -> outputDirProducer.produce((BuildItem)new ArgoCDOutputDirBuildItem.Effective(outputTarget.getOutputDirectory().resolve("argocd"))));
    }

    @BuildStep
    public void build(ArgoCDConfiguration config, ApplicationInfoBuildItem applicationInfo, List<FeatureBuildItem> features, List<KubernetesDeploymentTargetBuildItem> deploymentTargets, ScmInfoBuildItem scmInfo, Optional<CustomHelmOutputDirBuildItem> customHelmOutputDir, BuildProducer<ArgoCDResourceListBuildItem> resourceListProducer) {
        if (scmInfo == null) {
            log.warn((Object)"No SCM information found. Skipping argocd deployment generation.");
            return;
        }
        Optional deploymentTarget = deploymentTargets.stream().sorted().findFirst();
        boolean targetsOpenShift = deploymentTarget.filter(t -> t.getName().equals("openshift")).isPresent();
        String namespace = config.namespace.or(() -> config.project).orElse(targetsOpenShift ? ARGOCD_NAMESPACE_OPERNSHIFT : "argocd");
        String applicationNamespace = config.applicationNamespace.or(() -> config.namespace).orElse(null);
        Path helmOutputDir = customHelmOutputDir.map(CustomHelmOutputDirBuildItem::getOutputDir).orElse(Paths.get(".helm", new String[0]));
        AppProject project = ((AppProjectBuilder)((AppProjectFluent.SpecNested)((AppProjectFluent.SpecNested)((AppProjectSpecFluent.DestinationsNested)((AppProjectSpecFluent.DestinationsNested)((AppProjectBuilder)((AppProjectFluent.MetadataNested)((AppProjectFluent.MetadataNested)new AppProjectBuilder().withNewMetadata().withName(applicationInfo.getName())).withNamespace(namespace)).endMetadata()).withNewSpec().addNewDestination().withNamespace(applicationNamespace)).withServer(config.server)).endDestination()).withSourceRepos(new String[]{scmInfo.getDefaultRemoteUrl()})).endSpec()).build();
        Application deploy = ((ApplicationBuilder)((ApplicationFluent.SpecNested)((ApplicationSpecFluent.SyncPolicyNested)((SyncPolicyFluent.RetryNested)((RetryFluent.BackoffNested)((RetryFluent.BackoffNested)((RetryFluent.BackoffNested)((ApplicationSpecFluent.SyncPolicyNested)((ApplicationSpecFluent.SyncPolicyNested)((SyncPolicyFluent.AutomatedNested)((SyncPolicyFluent.AutomatedNested)((ApplicationFluent.SpecNested)((ApplicationSpecFluent.SourceNested)((SourceFluent.HelmNested)((ApplicationSpecFluent.SourceNested)((ApplicationSpecFluent.SourceNested)((ApplicationSpecFluent.SourceNested)((ApplicationFluent.SpecNested)((ApplicationSpecFluent.DestinationNested)((ApplicationSpecFluent.DestinationNested)((ApplicationFluent.SpecNested)((ApplicationBuilder)((ApplicationFluent.MetadataNested)((ApplicationFluent.MetadataNested)new ApplicationBuilder().withNewMetadata().withName(applicationInfo.getName())).withNamespace(namespace)).endMetadata()).withNewSpec().withProject(config.project.orElse(applicationInfo.getName()))).withNewDestination().withServer(config.server)).withNamespace(applicationNamespace)).endDestination()).withNewSource().withPath(helmOutputDir.resolve("kubernetes").resolve(applicationInfo.getName()).toString())).withRepoURL(scmInfo.getDefaultRemoteUrl())).withTargetRevision(config.targetRevision)).withNewHelm().withValueFiles(new String[]{"values.yaml"})).endApplicationspecHelm()).endApplicationspecSource()).withNewSyncPolicy().withNewAutomated().withPrune(Boolean.valueOf(true))).withSelfHeal(Boolean.valueOf(true))).endAutomated()).addToSyncOptions(new String[]{"CreateNamespace=true", "RespectIgnoreDifferences=true", "ApplyOutOfSyncOnly=true"})).withNewRetry().withNewBackoff().withDuration("5s")).withFactor(Long.valueOf(2L))).withMaxDuration("10m")).endSyncpolicyBackoff()).endSyncpolicyRetry()).endSyncPolicy()).endSpec()).build();
        ArgoCDResourceList resourceList = new ArgoCDResourceList();
        resourceList.setItems(List.of(project, deploy));
        resourceListProducer.produce((BuildItem)new ArgoCDResourceListBuildItem(resourceList));
    }

    @BuildStep(onlyIfNot={IsTest.class})
    public void generateApplicationFileSystemResources(ArgoCDResourceListBuildItem resourceList, OutputTargetBuildItem outputTarget, Optional<ArgoCDOutputDirBuildItem.Effective> outputDir, BuildProducer<GeneratedFileSystemResourceBuildItem> generatedResourceProducer) {
        if (resourceList == null || resourceList.getResourceList() == null) {
            return;
        }
        outputDir.ifPresent(dir -> {
            Path argocdRoot = dir.getOutputDir();
            for (HasMetadata item : resourceList.getResourceList().getItems()) {
                String kind = item.getKind().toLowerCase();
                String name = item.getMetadata().getName();
                Path path = argocdRoot.resolve(kind + "-" + name + ".yaml");
                String str = Serialization.asYaml(item);
                generatedResourceProducer.produce((BuildItem)new GeneratedFileSystemResourceBuildItem(path.toAbsolutePath().toString(), str.getBytes(StandardCharsets.UTF_8)));
            }
        });
    }

    private static Optional<Path> getScmRoot(OutputTargetBuildItem outputTarget) {
        Path dir;
        for (dir = outputTarget.getOutputDirectory(); dir != null && !dir.resolve(DOT_GIT).toFile().exists(); dir = dir.getParent()) {
        }
        return Optional.ofNullable(dir).filter(p -> p.resolve(DOT_GIT).toFile().exists());
    }

    private static Optional<String> getScmUrl(Path path) {
        try {
            return Git.getSafeRemoteUrl((Path)path, (String)"origin");
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private static Optional<String> getScmBranch(Path path) {
        try {
            return Git.getBranch((Path)path);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

