/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.argocd.deployment;

import io.quarkiverse.argocd.deployment.utils.Git;
import io.quarkus.builder.item.SimpleBuildItem;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;

public final class ScmInfoBuildItem
extends SimpleBuildItem {
    private final Path root;
    private final String branch;
    private final String commit;
    private final Map<String, String> remote;

    public ScmInfoBuildItem(Path root, Map<String, String> remote, String branch, String commit) {
        this.root = root;
        this.branch = branch;
        this.commit = commit;
        if (remote == null || remote.isEmpty()) {
            throw new IllegalArgumentException("remote cannot be blank");
        }
        this.remote = remote;
    }

    public Map<String, String> getRemote() {
        return this.remote;
    }

    public Path getRoot() {
        return this.root;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getCommit() {
        return this.commit;
    }

    public String getDefaultRemote() {
        return this.remote.containsKey("origin") ? "origin" : this.remote.keySet().iterator().next();
    }

    public String getDefaultRemoteUrl() {
        return Git.getRemoteUrl(this.root, this.getDefaultRemote(), true).orElseThrow();
    }

    public static Optional<ScmInfoBuildItem> fromPath(Path path) {
        Optional<ScmInfoBuildItem> scmInfo = Optional.empty();
        if (path == null) {
            return scmInfo;
        }
        try {
            Map remotes = io.dekorate.utils.Git.getRemotes((Path)path);
            if (remotes.isEmpty()) {
                return Optional.empty();
            }
            String branch = Git.getBranch(path).orElse(null);
            String sha = Git.getCommitSHA(path).orElse(null);
            scmInfo = Optional.of(new ScmInfoBuildItem(path, remotes, branch, sha));
            return scmInfo;
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

