/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.argocd.deployment.utils;

import io.dekorate.utils.Strings;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;

public class Git {
    public static Optional<String> getRemoteUrl(Path path, String remote, boolean httpsPreferred) {
        try {
            Optional<String> url = Files.lines(io.dekorate.utils.Git.getConfig((Path)path)).map(String::trim).filter(Git.inRemote(remote, new AtomicBoolean())).filter(l -> l.startsWith("url") && l.contains("=")).map(s -> s.split("=")[1].trim()).findAny();
            return httpsPreferred ? url.map(Git::sanitizeRemoteUrl) : url;
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static String sanitizeRemoteUrl(String remoteUrl) {
        if (remoteUrl == null || remoteUrl.isEmpty()) {
            throw new IllegalArgumentException("The remote URL cannot be null or empty.");
        }
        Object normalizedUrl = null;
        if (remoteUrl.startsWith("http://") || remoteUrl.startsWith("https://")) {
            normalizedUrl = remoteUrl.replaceAll("https?://[\\w%:]*@", "https://");
        } else if (remoteUrl.startsWith("git@")) {
            normalizedUrl = remoteUrl.replaceFirst("git@([\\w.-]+):", "https://$1/");
        } else {
            throw new IllegalArgumentException("Unsupported URL format: " + remoteUrl);
        }
        if (!((String)normalizedUrl).endsWith(".git")) {
            normalizedUrl = (String)normalizedUrl + ".git";
        }
        return normalizedUrl;
    }

    public static Optional<String> getBranch(Path path) {
        try {
            return Files.lines(io.dekorate.utils.Git.getHead((Path)path)).map(String::trim).filter(l -> l.startsWith("ref") && l.contains("/")).map(s -> s.substring(s.lastIndexOf("/") + 1).trim()).findAny();
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static Optional<String> getCommitSHA(Path path) {
        try {
            return Files.lines(io.dekorate.utils.Git.getHead((Path)path)).map(String::trim).filter(l -> l.startsWith("ref") && l.contains(":")).map(s -> s.substring(s.lastIndexOf(":") + 1).trim()).map(ref -> path.resolve(".git").resolve((String)ref)).filter(ref -> ref.toFile().exists()).map(Strings::read).map(String::trim).findAny();
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static Predicate<String> inRemote(String remote, AtomicBoolean state) {
        return l -> {
            if (l.startsWith("[") && l.contains("remote") && l.contains(remote) && l.endsWith("]")) {
                state.set(true);
            } else if (l.startsWith("[") && l.endsWith("]")) {
                state.set(false);
            }
            return state.get();
        };
    }
}

