/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.argocd.deployment.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import io.dekorate.utils.Streams;
import io.dekorate.utils.Strings;
import io.quarkiverse.argocd.v1alpha1.Application;
import io.quarkiverse.argocd.v1alpha1.ApplicationList;
import io.quarkiverse.argocd.v1alpha1.ArgoCDResourceList;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Serialization {
    private static final String DOCUMENT_DELIMITER = "---";
    private static final String TAG_PATTERN = "!<.*>";
    private static final String BLANK = "";
    private static JsonFactory JSON_FACTORY = new JsonFactory();
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper(JSON_FACTORY).registerModule((Module)new Jdk8Module()).setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    private static YAMLFactory YAML_FACTORY = new YAMLFactory().enable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER).enable(YAMLGenerator.Feature.MINIMIZE_QUOTES);
    private static final ObjectMapper YAML_MAPPER = new YAMLMapper(YAML_FACTORY).registerModule((Module)new Jdk8Module()).setSerializationInclusion(JsonInclude.Include.NON_EMPTY);

    public static ObjectMapper jsonMapper() {
        return JSON_MAPPER;
    }

    public static ObjectMapper yamlMapper() {
        return YAML_MAPPER;
    }

    public static <T> String asJson(T object) {
        try {
            if (object instanceof ArgoCDResourceList) {
                ArgoCDResourceList list = (ArgoCDResourceList)object;
                return Serialization.asYaml(list.getItems());
            }
            if (object instanceof List) {
                List list = (List)object;
                return list.stream().map(Serialization::writeValueAsJsonSafe).collect(Collectors.joining(",", "[", "]"));
            }
            return JSON_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> String asYaml(T object) {
        try {
            if (object instanceof ArgoCDResourceList) {
                ArgoCDResourceList list = (ArgoCDResourceList)object;
                if (list.getItems().size() == 1) {
                    return YAML_MAPPER.writeValueAsString(list.getItems().get(0)).replaceAll(TAG_PATTERN, BLANK);
                }
                return Serialization.asYaml(list.getItems());
            }
            if (object instanceof List) {
                List list = (List)object;
                return list.stream().map(Serialization::writeValueAsYamlSafe).map(s -> s.replaceAll(TAG_PATTERN, BLANK)).collect(Collectors.joining());
            }
            return YAML_MAPPER.writeValueAsString(object).replaceAll(TAG_PATTERN, BLANK);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Map<Object, Object>> unmarshalAsListOfMaps(Path file) throws IOException {
        return Serialization.unmarshalAsListOfMaps(Files.readString(file));
    }

    public static List<Map<Object, Object>> unmarshalAsListOfMaps(String content) throws IOException {
        String[] parts = Serialization.splitDocument(content);
        ArrayList<Map<Object, Object>> list = new ArrayList<Map<Object, Object>>();
        for (String part : parts) {
            if (part.trim().isEmpty()) continue;
            list.add((Map)Serialization.yamlMapper().readValue(part, (TypeReference)new TypeReference<Map<Object, Object>>(){}));
        }
        return list;
    }

    public static ApplicationList unmarshalAsList(InputStream is) {
        String content = Strings.read((InputStream)is);
        String[] parts = Serialization.splitDocument(content);
        ArrayList<Application> items = new ArrayList<Application>();
        for (String part : parts) {
            if (part.trim().isEmpty()) continue;
            Object resource = Serialization.unmarshal(part);
            if (resource instanceof ApplicationList) {
                items.addAll(((ApplicationList)resource).getItems());
                continue;
            }
            if (resource instanceof Application) {
                items.add((Application)resource);
                continue;
            }
            if (!(resource instanceof Application[])) continue;
            Arrays.stream((Application[])resource).forEach(r -> items.add((Application)r));
        }
        ApplicationList list = new ApplicationList();
        list.setItems(items);
        return list;
    }

    public static <T> T unmarshal(InputStream is) {
        return Serialization.unmarshal(is, JSON_MAPPER);
    }

    public static <T> T unmarshal(InputStream is, ObjectMapper mapper) {
        return Serialization.unmarshal(is, mapper, Collections.emptyMap());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static <T> T unmarshal(InputStream is, ObjectMapper mapper, Map<String, String> parameters) {
        try (FileInputStream fis = Streams.crateTempFileInputStream((InputStream)is);){
            Object object;
            try (BufferedInputStream bis = new BufferedInputStream(fis);){
                int intch;
                long readLimit = fis.getChannel().size();
                try {
                    bis.mark(Math.toIntExact(readLimit));
                }
                catch (ArithmeticException e) {
                    bis.mark(Integer.MAX_VALUE);
                }
                while ((intch = bis.read()) > -1 && Character.isWhitespace(intch)) {
                }
                bis.reset();
                if (intch != 123) {
                    mapper = YAML_MAPPER;
                }
                object = mapper.readerFor(Application.class).readValue((InputStream)bis);
            }
            return (T)object;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T unmarshal(String str) {
        try (ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8));){
            T t = Serialization.unmarshal(is);
            return t;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T unmarshal(String str, final Class<T> type) {
        try (ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8));){
            T t = Serialization.unmarshal((InputStream)is, new TypeReference<T>(){

                public Type getType() {
                    return type;
                }
            });
            return t;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T unmarshal(String str, TypeReference<T> type) {
        try (ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8));){
            T t = Serialization.unmarshal((InputStream)is, type);
            return t;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T unmarshal(InputStream is, final Class<T> type) {
        return Serialization.unmarshal(is, new TypeReference<T>(){

            public Type getType() {
                return type;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T unmarshal(File f, TypeReference<T> type) {
        try (FileInputStream is = new FileInputStream(f);){
            T t = Serialization.unmarshal((InputStream)is, type);
            return t;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T unmarshal(File f, final Class<T> type) {
        try (FileInputStream is = new FileInputStream(f);){
            T t = Serialization.unmarshal((InputStream)is, new TypeReference<T>(){

                public Type getType() {
                    return type;
                }
            });
            return t;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T unmarshal(URL u, final Class<T> type) {
        try (InputStream is = u.openStream();){
            T t = Serialization.unmarshal(is, new TypeReference<T>(){

                public Type getType() {
                    return type;
                }
            });
            return t;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T unmarshal(InputStream is, TypeReference<T> type) {
        try (BufferedInputStream bis = new BufferedInputStream(is);){
            int intch;
            bis.mark(-1);
            while ((intch = bis.read()) > -1 && Character.isWhitespace(intch)) {
            }
            bis.reset();
            ObjectMapper mapper = JSON_MAPPER;
            if (intch != 123) {
                mapper = YAML_MAPPER;
            }
            Object object = mapper.readValue((InputStream)bis, type);
            return (T)object;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String[] splitDocument(String aSpecFile) {
        ArrayList<String> documents = new ArrayList<String>();
        String[] lines = aSpecFile.split("\\r?\\n");
        StringBuilder builder = new StringBuilder();
        for (int nLine = 0; nLine < lines.length; ++nLine) {
            if (lines[nLine].length() >= DOCUMENT_DELIMITER.length() && !lines[nLine].substring(0, DOCUMENT_DELIMITER.length()).equals(DOCUMENT_DELIMITER) || lines[nLine].length() < DOCUMENT_DELIMITER.length()) {
                builder.append(lines[nLine] + System.lineSeparator());
                continue;
            }
            documents.add(builder.toString());
            builder.setLength(0);
            for (int i = 0; i <= nLine; ++i) {
                builder.append(System.lineSeparator());
            }
        }
        if (!builder.toString().isEmpty()) {
            documents.add(builder.toString());
        }
        return documents.toArray(new String[documents.size()]);
    }

    private static <T> String writeValueAsYamlSafe(T object) {
        try {
            return YAML_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> String writeValueAsJsonSafe(T object) {
        try {
            return JSON_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

