/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.artemis.jms.deployment;

import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.artemis.core.deployment.ArtemisBootstrappedBuildItem;
import io.quarkus.artemis.core.deployment.ArtemisCoreProcessor;
import io.quarkus.artemis.core.deployment.ArtemisJmsBuildItem;
import io.quarkus.artemis.core.deployment.ShadowRuntimeConfigs;
import io.quarkus.artemis.core.runtime.ArtemisBuildTimeConfig;
import io.quarkus.artemis.core.runtime.ArtemisBuildTimeConfigs;
import io.quarkus.artemis.jms.deployment.ArtemisJmsConfiguredBuildItem;
import io.quarkus.artemis.jms.runtime.ArtemisJmsRecorder;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.jms.spi.deployment.ConnectionFactoryWrapperBuildItem;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.XAConnectionFactory;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQXAConnectionFactory;

public class ArtemisJmsProcessor {
    private static final String FEATURE = "artemis-jms";

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void load(BuildProducer<ArtemisJmsBuildItem> artemisJms) {
        artemisJms.produce((BuildItem)new ArtemisJmsBuildItem());
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    ArtemisJmsConfiguredBuildItem configure(ArtemisJmsRecorder recorder, ShadowRuntimeConfigs shadowRunTimeConfigs, ArtemisBuildTimeConfigs buildTimeConfigs, ArtemisBootstrappedBuildItem bootstrap, Optional<ConnectionFactoryWrapperBuildItem> wrapperItem, BuildProducer<SyntheticBeanBuildItem> syntheticBeanProducer) {
        if (shadowRunTimeConfigs.isEmpty() && buildTimeConfigs.isEmpty()) {
            return new ArtemisJmsConfiguredBuildItem();
        }
        Function<ConnectionFactory, Object> wrapper = ArtemisJmsProcessor.getWrapper(recorder, wrapperItem);
        Set configurationNames = bootstrap.getConfigurationNames();
        boolean isSoleConnectionFactory = configurationNames.size() == 1;
        for (String name : configurationNames) {
            if (!shadowRunTimeConfigs.getNames().contains(name) && ((ArtemisBuildTimeConfig)buildTimeConfigs.configs().get(name)).isEmpty()) continue;
            Supplier connectionFactorySupplier = recorder.getConnectionFactoryProducer(name, wrapper);
            syntheticBeanProducer.produce((BuildItem)ArtemisJmsProcessor.toSyntheticBeanBuildItem(connectionFactorySupplier, name, isSoleConnectionFactory, ((ArtemisBuildTimeConfig)buildTimeConfigs.configs().get(name)).isXaEnabled()));
        }
        return new ArtemisJmsConfiguredBuildItem();
    }

    private static Function<ConnectionFactory, Object> getWrapper(ArtemisJmsRecorder recorder, Optional<ConnectionFactoryWrapperBuildItem> wrapperItem) {
        Function wrapper = wrapperItem.isPresent() ? wrapperItem.get().getWrapper() : recorder.getDefaultWrapper();
        return wrapper;
    }

    private static SyntheticBeanBuildItem toSyntheticBeanBuildItem(Supplier<ConnectionFactory> connectionFactorySupplier, String name, boolean isSoleConnectionFactory, boolean isXaEnable) {
        SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = (SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)ArtemisJmsProcessor.initializeConfigurator(isXaEnable).supplier(connectionFactorySupplier).scope(ApplicationScoped.class)).name(name);
        return ArtemisCoreProcessor.addQualifiers((String)name, (boolean)isSoleConnectionFactory, (SyntheticBeanBuildItem.ExtendedBeanConfigurator)configurator).setRuntimeInit().done();
    }

    private static SyntheticBeanBuildItem.ExtendedBeanConfigurator initializeConfigurator(boolean isXaEnable) {
        SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator;
        if (isXaEnable) {
            configurator = SyntheticBeanBuildItem.configure(ActiveMQXAConnectionFactory.class);
            configurator.addType(ActiveMQConnectionFactory.class);
            configurator.addType(XAConnectionFactory.class);
            configurator.addType(ConnectionFactory.class);
        } else {
            configurator = SyntheticBeanBuildItem.configure(ConnectionFactory.class);
        }
        return configurator;
    }
}

