/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.artemis.jms.ra.deployment;

import io.quarkiverse.ironjacamar.runtime.IronJacamarBuildtimeConfig;
import io.quarkus.artemis.jms.ra.deployment.ShadowIronJacamarRuntimeConfig;
import io.quarkus.artemis.jms.ra.runtime.ArtemisDevServicesBuildTimeConfig;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.DevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.devservices.common.ContainerLocator;
import io.quarkus.runtime.configuration.ConfigUtils;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class DevServicesArtemisProcessor {
    private static final Logger LOGGER = Logger.getLogger(DevServicesArtemisProcessor.class);
    public static final String DEFAULT_CONFIG_NAME = "<default>";
    private static final String QUARKUS_ARTEMIS_URL = "quarkus.ironjacamar.ra.config.connection-parameters";
    private static final String QUARKUS_ARTEMIS_NAMED_URL_TEMPLATE = "quarkus.ironjacamar.%s.ra.config.connection-parameters";
    static final String DEV_SERVICE_LABEL = "quarkus-dev-service-ironjacamar";
    static final int ARTEMIS_PORT = 61616;
    private static final ContainerLocator artemisContainerLocator = new ContainerLocator("quarkus-dev-service-ironjacamar", 61616);
    static final ConcurrentHashMap<String, DevServicesResultBuildItem.RunningDevService> devServices = new ConcurrentHashMap();
    static final ConcurrentHashMap<String, ArtemisDevServiceCfg> cfgs = new ConcurrentHashMap();
    static volatile boolean first = true;

    @BuildStep(onlyIfNot={IsNormal.class}, onlyIf={DevServicesConfig.Enabled.class})
    public List<DevServicesResultBuildItem> startArtemisDevService(DockerStatusBuildItem dockerStatusBuildItem, LaunchModeBuildItem launchMode, IronJacamarBuildtimeConfig buildConfig, ShadowIronJacamarRuntimeConfig runtimeConfig, ArtemisDevServicesBuildTimeConfig devServicesBuildTimeConfig, List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, CuratedApplicationShutdownBuildItem closeBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, DevServicesConfig devServicesConfig) {
        ArrayList<DevServicesResultBuildItem> results = new ArrayList<DevServicesResultBuildItem>();
        for (String name : buildConfig.resourceAdapters().keySet()) {
            boolean isUrlEmpty;
            ArtemisDevServiceCfg configuration = this.getConfiguration(devServicesBuildTimeConfig, name, isUrlEmpty = runtimeConfig.resourceAdapters().get(name).ra().config().connectionParameters().isEmpty());
            DevServicesResultBuildItem result = DevServicesArtemisProcessor.start(configuration, name, dockerStatusBuildItem, launchMode, consoleInstalledBuildItem, closeBuildItem, loggingSetupBuildItem, devServicesConfig);
            if (result == null) continue;
            results.add(result);
        }
        return results;
    }

    private static DevServicesResultBuildItem start(ArtemisDevServiceCfg configuration, String name, DockerStatusBuildItem dockerStatusBuildItem, LaunchModeBuildItem launchMode, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, CuratedApplicationShutdownBuildItem closeBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, DevServicesConfig devServicesConfig) {
        if (devServices.get(name) != null && configuration != null) {
            boolean shouldShutdownTheBroker;
            boolean bl = shouldShutdownTheBroker = !configuration.equals(cfgs.get(name));
            if (!shouldShutdownTheBroker) {
                return devServices.get(name).toBuildItem();
            }
            DevServicesArtemisProcessor.shutdownBroker(name);
            cfgs.clear();
        }
        if (configuration != null) {
            try (StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "ActiveMQ Artemis Dev Services Starting:", consoleInstalledBuildItem, loggingSetupBuildItem);){
                try {
                    DevServicesResultBuildItem.RunningDevService service = DevServicesArtemisProcessor.startArtemis(name, dockerStatusBuildItem, configuration, launchMode, devServicesConfig.timeout());
                    if (service != null) {
                        devServices.put(name, service);
                    }
                    if (devServices.get(name) == null) {
                        compressor.closeAndDumpCaptured();
                    }
                }
                catch (Throwable t) {
                    compressor.closeAndDumpCaptured();
                    throw t instanceof RuntimeException ? (RuntimeException)t : new RuntimeException(t);
                }
            }
        }
        if (devServices.get(name) == null) {
            return null;
        }
        if (first) {
            first = false;
            Runnable closeTask = () -> {
                for (String serviceName : devServices.keySet()) {
                    DevServicesArtemisProcessor.shutdownBroker(serviceName);
                }
                first = true;
                devServices.clear();
                cfgs.clear();
            };
            closeBuildItem.addCloseTask(closeTask, true);
        }
        cfgs.put(name, Objects.requireNonNull(configuration));
        if (devServices.get(name).isOwner()) {
            LOGGER.infof("Dev Services for ActiveMQ Artemis and named configuration %s started", (Object)name);
        }
        return devServices.get(name).toBuildItem();
    }

    private static String getArtemisUrl(String name) {
        return (String)devServices.get(name).getConfig().get(DevServicesArtemisProcessor.getUrlPropertyName(name));
    }

    private static String getUrlPropertyName(String name) {
        if (Objects.equals(DEFAULT_CONFIG_NAME, name)) {
            return QUARKUS_ARTEMIS_URL;
        }
        return String.format(QUARKUS_ARTEMIS_NAMED_URL_TEMPLATE, name);
    }

    private static void shutdownBroker(String name) {
        if (devServices.get(name) != null) {
            try {
                devServices.get(name).close();
            }
            catch (Throwable e) {
                LOGGER.error((Object)"Failed to stop the ActiveMQ Artemis broker", e);
            }
            finally {
                devServices.remove(name);
            }
        }
    }

    private static DevServicesResultBuildItem.RunningDevService startArtemis(String name, DockerStatusBuildItem dockerStatusBuildItem, ArtemisDevServiceCfg config, LaunchModeBuildItem launchMode, Optional<Duration> timeout) {
        if (!config.devServicesEnabled) {
            LOGGER.debugf("Not starting dev services for ActiveMQ Artemis and configuration %s, as it has been disabled in the config.", (Object)name);
            return null;
        }
        String urlPropertyName = DevServicesArtemisProcessor.getUrlPropertyName(name);
        if (ConfigUtils.isPropertyPresent((String)urlPropertyName)) {
            LOGGER.debugf("Not starting dev services for ActiveMQ Artemis and configuration %s, the quarkus.ironjacamar.ra.config.connection-parameters is configured.", (Object)name);
            return null;
        }
        if (!dockerStatusBuildItem.isContainerRuntimeAvailable()) {
            LOGGER.warn((Object)"Docker isn't working, please configure the connection parameters property (quarkus.ironjacamar.ra.config.connection-parameters).");
            return null;
        }
        Optional maybeContainerAddress = artemisContainerLocator.locateContainer(config.serviceName, config.shared, launchMode.getLaunchMode());
        String containerName = "ActiveMQ-Artemis " + name;
        Supplier<DevServicesResultBuildItem.RunningDevService> defaultArtemisBrokerSupplier = () -> {
            ArtemisContainer container = new ArtemisContainer(DockerImageName.parse((String)config.imageName), config.fixedExposedPort, config.user, config.password, config.extraArgs);
            container.withReuse(config.reuse);
            ConfigureUtil.configureSharedNetwork((GenericContainer)container, (String)"artemis");
            if (config.serviceName != null) {
                container.withLabel(DEV_SERVICE_LABEL, config.serviceName);
            }
            timeout.ifPresent(arg_0 -> ((ArtemisContainer)container).withStartupTimeout(arg_0));
            container.start();
            Map<String, String> configuration = DevServicesArtemisProcessor.createConnectionParameters(urlPropertyName, container.getHost(), container.getPort());
            return new DevServicesResultBuildItem.RunningDevService(containerName, container.getContainerId(), () -> ((ArtemisContainer)container).close(), configuration);
        };
        return maybeContainerAddress.map(containerAddress -> new DevServicesResultBuildItem.RunningDevService(containerName, containerAddress.getId(), null, DevServicesArtemisProcessor.createConnectionParameters(urlPropertyName, containerAddress.getHost(), containerAddress.getPort()))).orElseGet(defaultArtemisBrokerSupplier);
    }

    private static Map<String, String> createConnectionParameters(String urlPropertyName, String host, int port) {
        return Map.of(urlPropertyName, String.format("host=%s;port=%d;protocols=CORE", host, port));
    }

    private ArtemisDevServiceCfg getConfiguration(ArtemisDevServicesBuildTimeConfig devServicesBuildTimeConfig, String name, boolean isUrlEmpty) {
        if (devServicesBuildTimeConfig != null) {
            return new ArtemisDevServiceCfg(devServicesBuildTimeConfig, name, isUrlEmpty);
        }
        return null;
    }

    private static final class ArtemisDevServiceCfg {
        private final boolean devServicesEnabled;
        private final String imageName;
        private final Integer fixedExposedPort;
        private final boolean shared;
        private final String serviceName;
        private final String user;
        private final String password;
        private final String extraArgs;
        private final boolean reuse;

        public ArtemisDevServiceCfg(ArtemisDevServicesBuildTimeConfig devServicesConfig, String name, boolean isUrlEmpty) {
            this.devServicesEnabled = devServicesConfig.enabled().orElse(isUrlEmpty);
            this.imageName = devServicesConfig.getImageName();
            this.fixedExposedPort = devServicesConfig.getPort();
            this.shared = devServicesConfig.isShared();
            this.serviceName = devServicesConfig.getServiceName() + "-" + name;
            this.user = devServicesConfig.getUser();
            this.password = devServicesConfig.getPassword();
            this.extraArgs = devServicesConfig.getExtraArgs();
            this.reuse = devServicesConfig.reuse();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArtemisDevServiceCfg that = (ArtemisDevServiceCfg)o;
            return this.devServicesEnabled == that.devServicesEnabled && Objects.equals(this.imageName, that.imageName) && Objects.equals(this.fixedExposedPort, that.fixedExposedPort);
        }

        public int hashCode() {
            return Objects.hash(this.devServicesEnabled, this.imageName, this.fixedExposedPort);
        }
    }

    private static final class ArtemisContainer
    extends GenericContainer<ArtemisContainer> {
        private final int port;

        private ArtemisContainer(DockerImageName dockerImageName, int fixedExposedPort, String user, String password, String extra) {
            super(dockerImageName);
            this.port = fixedExposedPort;
            ((ArtemisContainer)((ArtemisContainer)((ArtemisContainer)((ArtemisContainer)((ArtemisContainer)this.withNetwork(Network.SHARED)).withExposedPorts(new Integer[]{61616, 8161})).withEnv("AMQ_USER", user)).withEnv("AMQ_PASSWORD", password)).withEnv("AMQ_EXTRA_ARGS", extra)).waitingFor((WaitStrategy)Wait.forLogMessage((String)".*AMQ241004.*", (int)1));
        }

        protected void configure() {
            super.configure();
            if (this.port > 0) {
                this.addFixedExposedPort(this.port, 61616);
                this.addFixedExposedPort(8161, 8161);
            }
        }

        public int getPort() {
            return this.getMappedPort(61616);
        }
    }
}

