/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.artemis.jms.ra;

import io.quarkiverse.ironjacamar.ResourceAdapterFactory;
import io.quarkiverse.ironjacamar.ResourceAdapterKind;
import io.quarkiverse.ironjacamar.ResourceAdapterTypes;
import io.quarkiverse.ironjacamar.runtime.endpoint.MessageEndpointWrapper;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.XAConnectionFactory;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ActivationSpec;
import jakarta.resource.spi.ManagedConnectionFactory;
import jakarta.resource.spi.ResourceAdapter;
import jakarta.resource.spi.endpoint.MessageEndpoint;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.ra.ActiveMQRAManagedConnectionFactory;
import org.apache.activemq.artemis.ra.ActiveMQResourceAdapter;
import org.apache.activemq.artemis.ra.inflow.ActiveMQActivationSpec;
import org.apache.activemq.artemis.utils.VersionLoader;

@ResourceAdapterKind(value="artemis")
@ResourceAdapterTypes(connectionFactoryTypes={ConnectionFactory.class, XAConnectionFactory.class})
public class ArtemisResourceAdapterFactory
implements ResourceAdapterFactory {
    public String getProductName() {
        return "ActiveMQ Artemis";
    }

    public String getProductVersion() {
        return VersionLoader.getVersion().getFullVersion();
    }

    public ActiveMQResourceAdapter createResourceAdapter(String id, Map<String, String> config) {
        ActiveMQResourceAdapter adapter = new ActiveMQResourceAdapter();
        String connectionParameters = config.get("connection-parameters");
        int hosts = Math.max(1, ArtemisResourceAdapterFactory.count(connectionParameters, "host="));
        String connectorClassName = NettyConnectorFactory.class.getName();
        adapter.setConnectorClassName(IntStream.rangeClosed(1, hosts).mapToObj(unused -> connectorClassName).collect(Collectors.joining(",")));
        adapter.setConnectionParameters(connectionParameters);
        adapter.setProtocolManagerFactoryStr(config.get("protocol-manager-factory"));
        adapter.setUseJNDI(Boolean.valueOf(false));
        adapter.setUserName(config.get("user"));
        adapter.setPassword(config.get("password"));
        adapter.setClientID(config.get("client-id"));
        adapter.setIgnoreJTA(Boolean.valueOf(false));
        return adapter;
    }

    public ManagedConnectionFactory createManagedConnectionFactory(String id, ResourceAdapter adapter) throws ResourceException {
        ActiveMQRAManagedConnectionFactory factory = new ActiveMQRAManagedConnectionFactory();
        factory.setResourceAdapter(adapter);
        factory.setAllowLocalTransactions(Boolean.valueOf(true));
        return factory;
    }

    public ActivationSpec createActivationSpec(String id, ResourceAdapter adapter, Class<?> type, Map<String, String> config) throws ResourceException {
        ActiveMQActivationSpec activationSpec = new ActiveMQActivationSpec();
        activationSpec.setResourceAdapter(adapter);
        activationSpec.setDestinationType(config.get("destination-type"));
        activationSpec.setDestination(config.get("destination"));
        activationSpec.setMaxSession(Integer.valueOf(config.getOrDefault("max-session", "5")));
        activationSpec.setMessageSelector(config.get("message-selector"));
        activationSpec.setShareSubscriptions(Boolean.valueOf(config.getOrDefault("share-subscriptions", "false")));
        activationSpec.setSubscriptionDurability(config.get("durability"));
        activationSpec.setSubscriptionName(config.get("subscription-name"));
        activationSpec.setRebalanceConnections(Boolean.valueOf(config.getOrDefault("rebalance-connections", "true")));
        activationSpec.setUseJNDI(Boolean.valueOf(false));
        return activationSpec;
    }

    public MessageEndpoint wrap(MessageEndpoint endpoint, Object resourceEndpoint) {
        return new JMSMessageEndpoint(endpoint, (MessageListener)resourceEndpoint);
    }

    private static int count(String text, String find) {
        int count = 0;
        int length = find.length();
        int index = 0;
        while ((index = text.indexOf(find, index)) != -1) {
            ++count;
            index += length;
        }
        return count;
    }

    private static class JMSMessageEndpoint
    extends MessageEndpointWrapper
    implements MessageListener {
        private final MessageListener listener;

        public JMSMessageEndpoint(MessageEndpoint messageEndpoint, MessageListener listener) {
            super(messageEndpoint);
            this.listener = listener;
        }

        public void onMessage(Message message) {
            this.listener.onMessage(message);
        }
    }
}

