/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.artemis.jms.ra.runtime;

import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import java.util.Optional;

@ConfigMapping(prefix="quarkus.ironjacamar.devservices")
@ConfigRoot(phase=ConfigPhase.BUILD_TIME)
public interface ArtemisDevServicesBuildTimeConfig {
    public Optional<Boolean> enabled();

    @WithDefault(value="false")
    public Boolean reuse();

    public Optional<Integer> port();

    public Optional<String> imageName();

    public Optional<Boolean> shared();

    public Optional<String> serviceName();

    public Optional<String> user();

    public Optional<String> password();

    public Optional<String> extraArgs();

    default public int getPort() {
        return this.port().orElse(0);
    }

    default public String getImageName() {
        return this.imageName().orElse("quay.io/arkmq-org/activemq-artemis-broker:artemis.2.40.0");
    }

    default public boolean isShared() {
        return this.shared().orElse(true);
    }

    default public String getServiceName() {
        return this.serviceName().orElse("artemis");
    }

    default public String getUser() {
        return this.user().orElse("admin");
    }

    default public String getPassword() {
        return this.password().orElse("admin");
    }

    default public String getExtraArgs() {
        return this.extraArgs().orElse("--no-autotune --mapped --no-fsync");
    }
}

