/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.artemis.jms.ra.runtime;

import io.quarkiverse.ironjacamar.runtime.IronJacamarBuildtimeConfig;
import io.quarkus.artemis.core.runtime.ArtemisUtil;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;

@Readiness
@ApplicationScoped
public class ConnectionFactoryHealthCheck
implements HealthCheck {
    private final Instance<ConnectionFactory> connectionFactories;
    private final Set<String> connectionFactoryNames;

    public ConnectionFactoryHealthCheck(IronJacamarBuildtimeConfig buildTimeConfigs, @Any Instance<ConnectionFactory> connectionFactories) {
        this.connectionFactories = connectionFactories;
        this.connectionFactoryNames = buildTimeConfigs.resourceAdapters().keySet();
    }

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder builder = HealthCheckResponse.named((String)"Artemis JMS Resource Adaptor health check").up();
        for (String name : this.connectionFactoryNames) {
            Annotation identifier = ArtemisUtil.toIdentifier((String)name);
            try {
                Connection ignored = ((ConnectionFactory)this.connectionFactories.select(new Annotation[]{identifier}).get()).createConnection();
                try {
                    builder.withData(name, "UP");
                }
                finally {
                    if (ignored == null) continue;
                    ignored.close();
                }
            }
            catch (Exception e) {
                builder.withData(name, "DOWN").down();
            }
        }
        return builder.build();
    }
}

