/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.artemis.jms.runtime;

import io.quarkus.artemis.core.runtime.ArtemisBuildTimeConfig;
import io.quarkus.artemis.core.runtime.ArtemisBuildTimeConfigs;
import io.quarkus.artemis.core.runtime.ArtemisRuntimeConfig;
import io.quarkus.artemis.core.runtime.ArtemisRuntimeConfigs;
import io.quarkus.artemis.core.runtime.ArtemisUtil;
import io.quarkus.artemis.jms.runtime.ArtemisJmsWrapper;
import io.quarkus.runtime.annotations.Recorder;
import java.util.Objects;
import java.util.function.Supplier;
import javax.jms.ConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;

@Recorder
public class ArtemisJmsRecorder {
    public ArtemisJmsWrapper getDefaultWrapper() {
        return new ArtemisJmsWrapper(){

            @Override
            public ConnectionFactory wrapConnectionFactory(ActiveMQConnectionFactory cf) {
                return cf;
            }
        };
    }

    public Supplier<ConnectionFactory> getConnectionFactoryProducer(final String name, ArtemisRuntimeConfigs runtimeConfigs, ArtemisBuildTimeConfigs buildTimeConfigs, final ArtemisJmsWrapper wrapper) {
        final ArtemisRuntimeConfig runtimeConfig = runtimeConfigs.getAllConfigs().getOrDefault(name, new ArtemisRuntimeConfig());
        final ArtemisBuildTimeConfig buildTimeConfig = buildTimeConfigs.getAllConfigs().getOrDefault(name, new ArtemisBuildTimeConfig());
        return new Supplier<ConnectionFactory>(){

            @Override
            public ConnectionFactory get() {
                ArtemisUtil.validateIntegrity((String)name, (ArtemisRuntimeConfig)runtimeConfig, (ArtemisBuildTimeConfig)buildTimeConfig);
                return Objects.requireNonNull(ArtemisJmsRecorder.this.extractConnectionFactory(runtimeConfig, wrapper));
            }
        };
    }

    private ConnectionFactory extractConnectionFactory(ArtemisRuntimeConfig runtimeConfig, ArtemisJmsWrapper wrapper) {
        String url = runtimeConfig.getUrl();
        if (url != null) {
            return wrapper.wrapConnectionFactory(new ActiveMQConnectionFactory(url, runtimeConfig.getUsername(), runtimeConfig.getPassword()));
        }
        return null;
    }
}

