/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.artemis.jms.runtime;

import io.quarkus.artemis.core.runtime.ArtemisBuildTimeConfig;
import io.quarkus.artemis.core.runtime.ArtemisBuildTimeConfigs;
import io.quarkus.artemis.core.runtime.ArtemisRuntimeConfig;
import io.quarkus.artemis.core.runtime.ArtemisRuntimeConfigs;
import io.quarkus.artemis.core.runtime.ArtemisUtil;
import io.quarkus.runtime.annotations.Recorder;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.jms.ConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;

@Recorder
public class ArtemisJmsRecorder {
    public Function<ConnectionFactory, Object> getDefaultWrapper() {
        return cf -> cf;
    }

    public Supplier<ConnectionFactory> getConnectionFactoryProducer(String name, ArtemisRuntimeConfigs runtimeConfigs, ArtemisBuildTimeConfigs buildTimeConfigs, Function<ConnectionFactory, Object> wrapper) {
        ArtemisRuntimeConfig runtimeConfig = runtimeConfigs.getAllConfigs().getOrDefault(name, new ArtemisRuntimeConfig());
        ArtemisBuildTimeConfig buildTimeConfig = buildTimeConfigs.getAllConfigs().getOrDefault(name, new ArtemisBuildTimeConfig());
        return () -> {
            ArtemisUtil.validateIntegrity((String)name, (ArtemisRuntimeConfig)runtimeConfig, (ArtemisBuildTimeConfig)buildTimeConfig);
            return Objects.requireNonNull(this.extractConnectionFactory(runtimeConfig, wrapper));
        };
    }

    private ConnectionFactory extractConnectionFactory(ArtemisRuntimeConfig runtimeConfig, Function<ConnectionFactory, Object> wrapper) {
        String url = runtimeConfig.getUrl();
        if (url != null) {
            return (ConnectionFactory)wrapper.apply((ConnectionFactory)new ActiveMQConnectionFactory(url, runtimeConfig.getUsername(), runtimeConfig.getPassword()));
        }
        return null;
    }
}

