/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.artemis.jms.runtime.health;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.artemis.core.runtime.ArtemisBuildTimeConfigs;
import io.quarkus.artemis.core.runtime.ArtemisRuntimeConfig;
import io.quarkus.artemis.core.runtime.ArtemisRuntimeConfigs;
import io.quarkus.artemis.core.runtime.ArtemisUtil;
import io.quarkus.artemis.core.runtime.health.ArtemisHealthSupport;
import io.smallrye.common.annotation.Identifier;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Default;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;

@Readiness
@ApplicationScoped
public class ConnectionFactoryHealthCheck
implements HealthCheck {
    private final HashMap<String, ConnectionFactory> connectionFactories = new HashMap();

    public ConnectionFactoryHealthCheck(ArtemisRuntimeConfigs runtimeConfigs, ArtemisBuildTimeConfigs buildTimeConfigs, ArtemisHealthSupport support) {
        HashSet<String> includedNames = new HashSet<String>(support.getConfiguredNames());
        includedNames.removeAll(support.getExcludedNames());
        this.processKnownBeans(runtimeConfigs, includedNames);
        this.processArcBeans(runtimeConfigs, buildTimeConfigs);
    }

    private void processKnownBeans(ArtemisRuntimeConfigs runtimeConfigs, HashSet<String> includedNames) {
        for (String name : includedNames) {
            ConnectionFactory connectionFactory;
            if (!((ArtemisRuntimeConfig)runtimeConfigs.configs().get(name)).isHealthInclude()) continue;
            Object identifier = ArtemisUtil.isDefault((String)name) ? Default.Literal.INSTANCE : Identifier.Literal.of((String)name);
            try (InstanceHandle handle = Arc.container().instance(ConnectionFactory.class, new Annotation[]{identifier});){
                connectionFactory = (ConnectionFactory)handle.get();
            }
            if (connectionFactory == null) continue;
            this.connectionFactories.put(name, connectionFactory);
        }
    }

    private void processArcBeans(ArtemisRuntimeConfigs runtimeConfigs, ArtemisBuildTimeConfigs buildTimeConfigs) {
        if (runtimeConfigs.getHealthExternalEnabled()) {
            HashSet namesToIgnore = new HashSet(runtimeConfigs.getNames());
            namesToIgnore.addAll(buildTimeConfigs.getNames());
            Map connectionFactoryNamesFromArc = ArtemisUtil.extractIdentifiers(ConnectionFactory.class, namesToIgnore);
            for (Map.Entry entry : connectionFactoryNamesFromArc.entrySet()) {
                ConnectionFactory connectionFactory = (ConnectionFactory)entry.getValue();
                if (connectionFactory == null) continue;
                this.connectionFactories.put((String)entry.getKey(), connectionFactory);
            }
        }
    }

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder builder = HealthCheckResponse.named((String)"Artemis JMS health check").up();
        for (Map.Entry<String, ConnectionFactory> entry : this.connectionFactories.entrySet()) {
            String name = entry.getKey();
            try {
                Connection ignored = entry.getValue().createConnection();
                try {
                    builder.withData(name, "UP");
                }
                finally {
                    if (ignored == null) continue;
                    ignored.close();
                }
            }
            catch (Exception e) {
                builder.withData(name, "DOWN").down();
            }
        }
        return builder.build();
    }
}

