/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.artemis.jms.runtime;

import io.quarkus.artemis.core.runtime.ArtemisBuildTimeConfig;
import io.quarkus.artemis.core.runtime.ArtemisBuildTimeConfigs;
import io.quarkus.artemis.core.runtime.ArtemisRuntimeConfig;
import io.quarkus.artemis.core.runtime.ArtemisRuntimeConfigs;
import io.quarkus.artemis.core.runtime.ArtemisUtil;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import jakarta.jms.ConnectionFactory;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQXAConnectionFactory;

@Recorder
public class ArtemisJmsRecorder {
    private final ArtemisBuildTimeConfigs buildTimeConfigs;
    private final RuntimeValue<ArtemisRuntimeConfigs> runtimeConfigs;

    public ArtemisJmsRecorder(ArtemisBuildTimeConfigs buildTimeConfigs, RuntimeValue<ArtemisRuntimeConfigs> runtimeConfigs) {
        this.buildTimeConfigs = buildTimeConfigs;
        this.runtimeConfigs = runtimeConfigs;
    }

    public Function<ConnectionFactory, Object> getDefaultWrapper() {
        return cf -> cf;
    }

    public Supplier<ConnectionFactory> getConnectionFactoryProducer(String name, Function<ConnectionFactory, Object> wrapper) {
        ArtemisRuntimeConfig runtimeConfig = (ArtemisRuntimeConfig)((ArtemisRuntimeConfigs)this.runtimeConfigs.getValue()).configs().get(name);
        ArtemisBuildTimeConfig buildTimeConfig = (ArtemisBuildTimeConfig)this.buildTimeConfigs.configs().get(name);
        ArtemisUtil.validateIntegrity((String)name, (ArtemisRuntimeConfig)runtimeConfig, (ArtemisBuildTimeConfig)buildTimeConfig);
        ConnectionFactory connectionFactory = Objects.requireNonNull(this.extractConnectionFactory(buildTimeConfig.isXaEnabled(), runtimeConfig, wrapper));
        return () -> connectionFactory;
    }

    private ConnectionFactory extractConnectionFactory(boolean isXaEnabled, ArtemisRuntimeConfig runtimeConfig, Function<ConnectionFactory, Object> wrapper) {
        String url = runtimeConfig.getUrl();
        if (url != null) {
            if (isXaEnabled) {
                return (ConnectionFactory)wrapper.apply((ConnectionFactory)new ActiveMQXAConnectionFactory(url, runtimeConfig.getUsername(), runtimeConfig.getPassword()));
            }
            return (ConnectionFactory)wrapper.apply((ConnectionFactory)new ActiveMQConnectionFactory(url, runtimeConfig.getUsername(), runtimeConfig.getPassword()));
        }
        return null;
    }
}

