/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.artemis.test;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.server.embedded.EmbeddedActiveMQ;
import org.apache.commons.io.FileUtils;

public class ArtemisTestResource
implements QuarkusTestResourceLifecycleManager {
    private static final String DEFAULT_CONFIGURATION_NAME = "<default>";
    private static final String QUARKUS_ARTEMIS_CONFIG_PREFIX = "quarkus.artemis";
    private final String configurationName;
    private final String configurationPrefix;
    private EmbeddedActiveMQ embedded;

    public ArtemisTestResource() {
        this(DEFAULT_CONFIGURATION_NAME);
    }

    protected ArtemisTestResource(String configurationName) {
        this(QUARKUS_ARTEMIS_CONFIG_PREFIX, configurationName);
    }

    protected ArtemisTestResource(String configurationPrefix, String configurationName) {
        this.configurationPrefix = configurationPrefix;
        this.configurationName = Objects.requireNonNull(configurationName);
    }

    public Map<String, String> start() {
        try {
            Path artemisPath = Path.of(".", "target", "artemis", ArtemisTestResource.getFileSystemSafeName(this.configurationName));
            FileUtils.deleteDirectory((File)artemisPath.toFile());
            this.embedded = new EmbeddedActiveMQ().setConfigResourcePath(this.getConfigurationFileName());
            this.embedded.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not start embedded ActiveMQ server for configuration " + this.configurationName, e);
        }
        for (TransportConfiguration config : this.embedded.getConfiguration().getAcceptorConfigurations()) {
            if (!config.getName().equals("activemq")) continue;
            return Collections.singletonMap(this.getUrlConfigKey(), String.format("tcp://%s:%s", config.getParams().get("host"), config.getParams().get("port")));
        }
        return Collections.emptyMap();
    }

    private String getConfigurationFileName() {
        if (this.configurationName.equals(DEFAULT_CONFIGURATION_NAME)) {
            return "broker.xml";
        }
        return String.format("broker-%s.xml", ArtemisTestResource.getFileSystemSafeName(this.configurationName));
    }

    private static String getFileSystemSafeName(String name) {
        return name.replaceAll("[^A-Za-z0-9_.-]", "_");
    }

    private String getUrlConfigKey() {
        if (this.configurationName.equals(DEFAULT_CONFIGURATION_NAME)) {
            return "quarkus.artemis.url";
        }
        if (this.configurationPrefix.equals(QUARKUS_ARTEMIS_CONFIG_PREFIX)) {
            return String.format("%s.\"%s\".url", this.configurationPrefix, this.configurationName);
        }
        return String.format("%s.%s.url", this.configurationPrefix, this.configurationName);
    }

    public void stop() {
        if (this.embedded != null) {
            try {
                this.embedded.stop();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not stop embedded ActiveMQ server for configuration " + this.configurationName, e);
            }
        }
    }
}

