/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.asyncapi.generator;

import com.asyncapi.v2._6_0.model.AsyncAPI;
import io.quarkiverse.asyncapi.config.AsyncAPISupplier;
import io.quarkiverse.asyncapi.config.AsyncAPIUtils;
import io.quarkiverse.asyncapi.config.ObjectMapperFactory;
import io.quarkiverse.asyncapi.generator.AsyncApiConfigGroup;
import io.quarkiverse.asyncapi.generator.QuteTemplateHelper;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;

public class AsyncApiCodeGenerator {
    private final Path outPath;
    private final Config config;
    private final String basePackage;
    private static final String DEFAULT_PACKAGE = "io.quarkiverse.asyncapi";
    static final String SERVICE_LOADER = "org.eclipse.microprofile.config.spi.ConfigSource";
    private static final String CONFIG_SOURCE = "ConfigSource";
    private static final String PRODUCER_NAME = "AsyncAPISupplier";
    private static final String JAVA_SUFFIX = ".java";
    private final Collection<String> configClassNames = new HashSet<String>();
    private final Collection<String> asyncSupplierClassNames = new HashSet<String>();

    public AsyncApiCodeGenerator(Path outPath, Config config, Optional<String> packageName) {
        this.outPath = outPath;
        this.config = config;
        this.basePackage = packageName.orElse(config.getOptionalValue(AsyncApiConfigGroup.PACKAGE_PROP, String.class).orElse(DEFAULT_PACKAGE));
    }

    public void generate(Path path) throws IOException {
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            this.generate(path.getFileName().toString(), is);
        }
    }

    public void generate(String id, InputStream stream) throws IOException {
        id = AsyncAPIUtils.getJavaClassName((String)id);
        AsyncAPI asyncAPI = (AsyncAPI)ObjectMapperFactory.yaml().readValue(stream, AsyncAPI.class);
        Map<String, Object> data = Map.of("id", id, "packageName", this.basePackage, "asyncAPI", this.escape(ObjectMapperFactory.json().writeValueAsString((Object)asyncAPI)));
        this.configClassNames.add(this.writeTemplate(id, CONFIG_SOURCE, data));
        this.asyncSupplierClassNames.add(this.writeTemplate(id, PRODUCER_NAME, data));
    }

    private String escape(String raw) {
        String escaped = raw;
        escaped = escaped.replace("\\", "\\\\");
        escaped = escaped.replace("\"", "\\\"");
        escaped = escaped.replace("\b", "\\b");
        escaped = escaped.replace("\f", "\\f");
        escaped = escaped.replace("\n", "\\n");
        escaped = escaped.replace("\r", "\\r");
        escaped = escaped.replace("\t", "\\t");
        return escaped;
    }

    private String writeTemplate(String id, String templateName, Map<String, Object> map) throws IOException {
        Files.writeString(Files.createDirectories(this.outPath.resolve(this.basePackage.replace('.', '/')).resolve(id), new FileAttribute[0]).resolve(templateName + JAVA_SUFFIX), (CharSequence)QuteTemplateHelper.getTemplate(this.config, templateName).data(map).render(), new OpenOption[0]);
        return this.basePackage + "." + id + "." + templateName;
    }

    public boolean done(boolean test) throws IOException {
        boolean result = this.writeServiceLoader(this.configClassNames, SERVICE_LOADER, test);
        return result |= this.writeServiceLoader(this.asyncSupplierClassNames, AsyncAPISupplier.class.getCanonicalName(), test);
    }

    private boolean writeServiceLoader(Collection<String> implClasses, String implementationClass, boolean test) throws IOException {
        if (implClasses.isEmpty()) {
            return false;
        }
        Path serviceLoader = Files.createDirectories(this.outPath.getParent().getParent().resolve(test ? "test-classes" : "classes").resolve("META-INF").resolve("services"), new FileAttribute[0]).resolve(implementationClass);
        try (BufferedWriter w = Files.newBufferedWriter(serviceLoader, new OpenOption[0]);){
            for (String implName : implClasses) {
                w.write(implName);
                w.write(System.lineSeparator());
            }
        }
        return true;
    }
}

