/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.asyncapi.generator.input;

import io.quarkiverse.asyncapi.config.AsyncAPIExtension;
import io.quarkiverse.asyncapi.generator.AsyncApiCodeGenerator;
import io.quarkiverse.asyncapi.generator.AsyncApiConfigGroup;
import io.quarkiverse.asyncapi.generator.input.AsyncApiGeneratorCodeGenBase;
import io.quarkus.deployment.CodeGenContext;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.Config;

public class AsyncApiPathGeneratorCodeGen
extends AsyncApiGeneratorCodeGenBase {
    protected AsyncApiPathGeneratorCodeGen(AsyncAPIExtension extension) {
        super(extension);
    }

    protected Collection<String> excludedFiles(Config config) {
        return config.getOptionalValues(AsyncApiConfigGroup.EXCLUDED_FILES_PROP, String.class).orElse(Collections.emptyList());
    }

    @Override
    protected void trigger(CodeGenContext context, AsyncApiCodeGenerator generator) throws IOException {
        Path specDir = context.inputDir();
        Collection<String> ignoredFiles = this.excludedFiles(context.config());
        if (Files.isDirectory(specDir, new LinkOption[0])) {
            try (Stream<Path> specFilePaths = Files.walk(specDir, new FileVisitOption[0]);){
                Collection files = specFilePaths.filter(path -> this.isCandidateFile((Path)path, ignoredFiles)).collect(Collectors.toList());
                for (Path file : files) {
                    generator.generate(file);
                }
            }
        }
    }

    protected boolean isCandidateFile(Path path, Collection<String> ignoredFiles) {
        String fileName = path.getFileName().toString();
        return Files.isRegularFile(path, new LinkOption[0]) && fileName.endsWith(this.inputExtension()) && !ignoredFiles.contains(fileName);
    }

    @Override
    protected Collection<AsyncApiCodeGenerator> buildCodeGenerators(CodeGenContext context) {
        return List.of(new AsyncApiCodeGenerator(context.outDir(), context.config(), Optional.empty()));
    }
}

