/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.asyncapi.annotation.scanner;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.ConfigProvider;

public class AsyncApiHandler
implements Handler<RoutingContext> {
    private static final Logger LOGGER = Logger.getLogger(AsyncApiHandler.class.getName());
    static final String HTML_PATTERN = "<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <script src=\"https://unpkg.com/@webcomponents/webcomponentsjs@%s/webcomponents-bundle.js\"></script>\n    <script\n      src=\"https://unpkg.com/@asyncapi/web-component@%s/lib/asyncapi-web-component.js\"\n      defer\n    ></script>\n  </head>\n  <body>\n    <asyncapi-component\n      cssImportPath=\"https://unpkg.com/@asyncapi/react-component@%s/styles/default.css\"\n      schemaUrl=\"%s/asyncapi.yaml\"\n    >\n    </asyncapi-component>\n  </body>\n</html>\n";
    static final String PUML_PATTERN = "<!DOCTYPE html>\n<html lang=\"en\">\n<head>\n</head>\n<body>\n<uml>%s</uml>\n<br>\n<script src=\"//code.jquery.com/jquery.min.js\"></script>\n<script src=\"//cdn.rawgit.com/jmnote/plantuml-encoder/d133f316/dist/plantuml-encoder.min.js\"></script>\n<script>\n$(\"uml\").each(function() {\n  var src = \"//www.plantuml.com/plantuml/svg/\" + window.plantumlEncoder.encode( $(this).text() )\n  $(this).replaceWith($('<img>').attr('src', src));\n});\n</script>\n</body>\n\n</html>";

    public void handle(RoutingContext aRoutingContext) {
        HttpServerResponse resp = aRoutingContext.response();
        if (((Boolean)ConfigProvider.getConfig().getValue("quarkus.asyncapi.annotation.scanner.enabled", Boolean.class)).booleanValue()) {
            String output;
            Format format = this.getFormat(aRoutingContext);
            resp.headers().set("Content-Type", format.getMimeType() + ";charset=UTF-8");
            switch (format) {
                case HTML: {
                    output = this.getHtml(aRoutingContext);
                    break;
                }
                case SVG: {
                    output = String.format(PUML_PATTERN, this.readFile(Format.SVG));
                    break;
                }
                default: {
                    output = this.readFile(format);
                }
            }
            resp.end(Buffer.buffer((String)output));
        } else {
            resp.headers().set("Content-Type", "text/plain;charset=UTF-8");
            resp.end("Async API disabled (see config asyncapi.annotation.scanner.enabled)");
        }
    }

    String readFile(Format aFormat) {
        try {
            Path path = Paths.get(System.getProperty("java.io.tmpdir"), aFormat.getFileName());
            return Files.readString(path);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "AsyncApiHandler.read() Unable to read file as " + aFormat, e);
            return "Unable to read file";
        }
    }

    String getHtml(RoutingContext aRoutingContext) {
        String version = (String)ConfigProvider.getConfig().getValue("quarkus.asyncapi.annotation.scanner.webcomponentversion", String.class);
        String rootPath = (String)ConfigProvider.getConfig().getValue("quarkus.http.root-path", String.class);
        return String.format(HTML_PATTERN, version, version, version, rootPath, rootPath);
    }

    Format getFormat(RoutingContext aRoutingContext) {
        String path = aRoutingContext.normalizedPath();
        Format format = Format.YAML;
        if (path.endsWith(".json")) {
            format = Format.JSON;
        } else if (path.endsWith(".yaml") || path.endsWith(".yml")) {
            format = Format.YAML;
        } else if (path.endsWith(".html")) {
            format = Format.HTML;
        } else if (path.endsWith(".puml")) {
            format = Format.PUML;
        } else if (path.endsWith(".svg")) {
            format = Format.SVG;
        } else {
            String formatParam;
            String accept = aRoutingContext.request().headers().get("Accept");
            List formatParams = aRoutingContext.queryParam("format");
            String string = formatParam = formatParams.isEmpty() ? null : (String)formatParams.get(0);
            if (accept != null && accept.contains(Format.JSON.getMimeType()) || "JSON".equalsIgnoreCase(formatParam)) {
                format = Format.JSON;
            }
        }
        return format;
    }

    static enum Format {
        JSON("application/json", "asyncApi.json"),
        YAML("application/yaml", "asyncApi.yaml"),
        HTML("text/html", null),
        PUML("text/plain", "asyncApi.puml"),
        SVG("text/html", "asyncApi.puml");

        private final String mimeType;
        private final String fileName;

        private Format(String aMimeType, String aFileName) {
            this.mimeType = aMimeType;
            this.fileName = aFileName;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public String getFileName() {
            return this.fileName;
        }
    }
}

