/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.asyncapi.annotation.scanner;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;

public class ObjectMapperFactory {
    private static ObjectMapper jsonObjectMapper = ObjectMapperFactory.setupMapper(new ObjectMapper());
    private static ObjectMapper ymlObjectMapper = ObjectMapperFactory.setupMapper(new ObjectMapper((JsonFactory)new YAMLFactory()));

    private ObjectMapperFactory() {
    }

    private static ObjectMapper setupMapper(ObjectMapper mapper) {
        return mapper.findAndRegisterModules().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    }

    public static ObjectMapper yaml() {
        return ymlObjectMapper;
    }

    public static ObjectMapper json() {
        return jsonObjectMapper;
    }
}

