/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.asyncapi.annotation.scanner.kafka.binding;

import com.asyncapi.v2.binding.channel.kafka.KafkaChannelBinding;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.config.ConfigResource;
import org.eclipse.microprofile.config.ConfigProvider;

public class KafkaResolver {
    private static final Logger LOGGER = Logger.getLogger(KafkaResolver.class.getName());
    static final String CLEANUP_POLICY = "cleanup.policy";
    static final String RETENTION_MS = "retention.ms";
    static final String RETENTION_BYTES = "retention.bytes";
    static final String DELETE_RETENTION_MS = "delete.retention.ms";
    static final String MAX_MESSAGE_BYTES = "max.message.bytes";
    private AdminClient adminClient;

    public KafkaChannelBinding getKafkaChannelBindings(String aTopic) {
        KafkaChannelBinding.KafkaChannelBindingBuilder builder = KafkaChannelBinding.builder().topic(aTopic);
        Optional bootStrapServers = ConfigProvider.getConfig().getOptionalValue("kafka.bootstrap.servers", String.class);
        if (bootStrapServers.isPresent()) {
            Map properties = Map.of("bootstrap.servers", bootStrapServers.get());
            if (this.adminClient == null) {
                this.adminClient = AdminClient.create(properties);
            }
            try {
                if (this.isTopicExists(this.adminClient, aTopic)) {
                    DescribeTopicsResult topicDescription = this.adminClient.describeTopics(Set.of(aTopic), new DescribeTopicsOptions().timeoutMs(Integer.valueOf(100)));
                    List partitionInfos = ((TopicDescription)((KafkaFuture)topicDescription.topicNameValues().get(aTopic)).get()).partitions();
                    builder.partitions(Integer.valueOf(partitionInfos.size())).replicas(Integer.valueOf(((TopicPartitionInfo)partitionInfos.get(0)).replicas().size())).topicConfiguration(this.getTopicConfiguration(this.adminClient, aTopic));
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                LOGGER.log(Level.WARNING, "Unable to describe topic {0}", aTopic);
            }
        } else {
            LOGGER.log(Level.WARNING, "No kafka.bootstrap.server configured");
        }
        return builder.build();
    }

    KafkaChannelBinding.TopicConfiguration getTopicConfiguration(AdminClient aClient, String aTopic) {
        Map configMap = aClient.describeConfigs(List.of(new ConfigResource(ConfigResource.Type.TOPIC, aTopic))).values().values().stream().map(f -> {
            try {
                return (Config)f.get();
            }
            catch (InterruptedException | ExecutionException interruptedException) {
                return null;
            }
        }).filter(Objects::nonNull).map(Config::entries).flatMap(Collection::stream).collect(Collectors.toMap(ConfigEntry::name, Function.identity()));
        return KafkaChannelBinding.TopicConfiguration.builder().cleanupPolicy(List.of(((ConfigEntry)configMap.get(CLEANUP_POLICY)).value())).retentionMs(Integer.valueOf(((ConfigEntry)configMap.get(RETENTION_MS)).value())).retentionBytes(Integer.valueOf(((ConfigEntry)configMap.get(RETENTION_BYTES)).value())).deleteRetentionMs(Integer.valueOf(((ConfigEntry)configMap.get(DELETE_RETENTION_MS)).value())).maxMessageBytes(Integer.valueOf(((ConfigEntry)configMap.get(MAX_MESSAGE_BYTES)).value())).build();
    }

    private boolean isTopicExists(AdminClient admin, String topicName) throws InterruptedException, ExecutionException {
        return ((Set)admin.listTopics(new ListTopicsOptions().timeoutMs(Integer.valueOf(100))).names().get()).contains(topicName);
    }

    public void close() {
        if (this.adminClient != null) {
            this.adminClient.close();
        }
    }
}

