/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.asyncapi.config.channels;

import com.asyncapi.v2.model.channel.ChannelItem;
import com.asyncapi.v2.model.channel.operation.Operation;
import com.asyncapi.v2.model.server.Server;
import io.quarkiverse.asyncapi.config.channels.ChannelConfigurer;
import java.util.Map;

public abstract class AbstractChannelConfigurer
implements ChannelConfigurer {
    private static final String INCOMING_CHANNEL_PATTERN = "mp.messaging.incoming.%s.%s";
    private static final String OUTGOING_CHANNEL_PATTERN = "mp.messaging.outgoing.%s.%s";
    public static final String CONNECTOR = "connector";
    private final String protocol;
    private final String connectorId;

    protected final String outgoingProperty(String channel, String property) {
        return String.format(OUTGOING_CHANNEL_PATTERN, channel, property);
    }

    protected final String incomingProperty(String channel, String property) {
        return String.format(INCOMING_CHANNEL_PATTERN, channel, property);
    }

    protected AbstractChannelConfigurer(String protocol, String connectorId) {
        this.protocol = protocol;
        this.connectorId = connectorId;
    }

    @Override
    public String protocol() {
        return this.protocol;
    }

    @Override
    public void channelConfig(String channelName, ChannelItem item, Server server, Map<String, String> result) {
        if (item.getSubscribe() != null) {
            String incomingChannel = channelName;
            result.put(this.incomingProperty(incomingChannel, CONNECTOR), this.connectorId);
            this.addIncomingChannel(incomingChannel, channelName, item.getPublish(), server, result);
        }
        if (item.getPublish() != null) {
            String outgoingChannel = channelName + "_out";
            result.put(this.outgoingProperty(outgoingChannel, CONNECTOR), this.connectorId);
            this.addOutgoingChannel(outgoingChannel, channelName, item.getPublish(), server, result);
        }
    }

    @Override
    public void commonConfig(Server server, Map<String, String> result) {
    }

    protected abstract void addOutgoingChannel(String var1, String var2, Operation var3, Server var4, Map<String, String> var5);

    protected abstract void addIncomingChannel(String var1, String var2, Operation var3, Server var4, Map<String, String> var5);
}

