/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.asyncapi.config.channels;

import com.asyncapi.v2.model.server.Server;
import io.quarkiverse.asyncapi.config.channels.ChannelConfigurer;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ChannelConfigurerFactory {
    private static Map<String, ChannelConfigurer> configurers = ServiceLoader.load(ChannelConfigurer.class).stream().map(provider -> (ChannelConfigurer)provider.get()).collect(Collectors.toMap(ChannelConfigurer::protocol, Function.identity()));

    private ChannelConfigurerFactory() {
    }

    public static ChannelConfigurer get(Server server) {
        return Objects.requireNonNull(configurers.get(server.getProtocol()), "Unsupported protocol " + server.getProtocol());
    }
}

