/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.asyncapi.config;

import com.asyncapi.v2._6_0.model.AsyncAPI;
import com.asyncapi.v2._6_0.model.channel.ChannelItem;
import com.asyncapi.v2._6_0.model.server.Server;
import io.quarkiverse.asyncapi.config.AsyncAPISupplier;
import io.quarkiverse.asyncapi.config.channels.ChannelConfigurer;
import io.quarkiverse.asyncapi.config.channels.ChannelConfigurerFactory;
import io.smallrye.config.common.MapBackedConfigSource;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncConfigSource
extends MapBackedConfigSource {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(AsyncConfigSource.class);

    public AsyncConfigSource(AsyncAPISupplier asyncAPISupplier) {
        super(asyncAPISupplier.id(), AsyncConfigSource.getMapFromAsyncApi(asyncAPISupplier.asyncAPI()));
    }

    private static Map<String, String> getMapFromAsyncApi(AsyncAPI asyncAPI) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Server server : asyncAPI.getServers().values()) {
            ChannelConfigurer configurer = ChannelConfigurerFactory.get(server);
            configurer.commonConfig(server, result);
            for (Map.Entry entry : asyncAPI.getChannels().entrySet()) {
                configurer.channelConfig((String)entry.getKey(), (ChannelItem)entry.getValue(), server, result);
            }
        }
        logger.debug("Produced config source {}", result);
        return result;
    }
}

