/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.asyncapi.config.channels;

import com.asyncapi.v2._6_0.model.channel.operation.Operation;
import com.asyncapi.v2._6_0.model.server.Server;
import io.quarkiverse.asyncapi.config.channels.AbstractChannelConfigurer;
import java.util.Map;

public class KafkaChannelConfigurer
extends AbstractChannelConfigurer {
    private static final String KAFKA_SERIALIZER = "value.serializer";
    private static final String KAFKA_DESERIALIZER = "value.deserializer";
    private static final String TOPIC = "topic";

    public KafkaChannelConfigurer() {
        super("kafka", "smallrye-kafka");
    }

    @Override
    protected void addOutgoingChannel(String smallryeChannel, String channelName, Operation operation, Server server, Map<String, String> result) {
        result.put(this.outgoingProperty(smallryeChannel, TOPIC), channelName);
        result.put(this.outgoingProperty(smallryeChannel, KAFKA_SERIALIZER), "org.apache.kafka.common.serialization.ByteArraySerializer");
    }

    @Override
    protected void addIncomingChannel(String smallryeChannel, String channelName, Operation operation, Server server, Map<String, String> result) {
        result.put(this.incomingProperty(smallryeChannel, TOPIC), channelName);
        result.put(this.incomingProperty(smallryeChannel, KAFKA_DESERIALIZER), "org.apache.kafka.common.serialization.ByteArrayDeserializer");
    }

    @Override
    public void commonConfig(Server server, Map<String, String> result) {
        String serverUri = server.getUrl();
        result.compute("kafka.bootstrap.servers", (k, v) -> v == null ? serverUri : v + "," + serverUri);
    }
}

