/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.azure.eventhubs.runtime;

import com.azure.core.credential.TokenCredential;
import com.azure.core.util.ClientOptions;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.messaging.eventhubs.EventHubClientBuilder;
import com.azure.messaging.eventhubs.EventHubConsumerAsyncClient;
import com.azure.messaging.eventhubs.EventHubConsumerClient;
import com.azure.messaging.eventhubs.EventHubProducerAsyncClient;
import com.azure.messaging.eventhubs.EventHubProducerClient;
import io.quarkiverse.azure.eventhubs.runtime.EventhubsConfig;
import io.quarkus.runtime.configuration.ConfigurationException;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;

public class EventhubsClientProducer {
    @Inject
    EventhubsConfig eventhubsConfig;

    @Produces
    public EventHubProducerClient createEventHubProducerClient() {
        if (!this.eventhubsConfig.enabled()) {
            return null;
        }
        EventHubClientBuilder builder = this.getBuilder();
        return null == builder ? null : builder.buildProducerClient();
    }

    @Produces
    public EventHubProducerAsyncClient createEventHubProducerAsyncClient() {
        if (!this.eventhubsConfig.enabled()) {
            return null;
        }
        EventHubClientBuilder builder = this.getBuilder();
        return null == builder ? null : builder.buildAsyncProducerClient();
    }

    @Produces
    public EventHubConsumerClient createEventHubConsumerClient() {
        if (!this.eventhubsConfig.enabled()) {
            return null;
        }
        EventHubClientBuilder builder = this.getBuilder();
        return null == builder ? null : builder.consumerGroup("$Default").buildConsumerClient();
    }

    @Produces
    public EventHubConsumerAsyncClient createEventhubClient() {
        if (!this.eventhubsConfig.enabled()) {
            return null;
        }
        EventHubClientBuilder builder = this.getBuilder();
        return null == builder ? null : builder.consumerGroup("$Default").buildAsyncConsumerClient();
    }

    private EventHubClientBuilder getBuilder() {
        if (!this.eventhubsConfig.enabled()) {
            return null;
        }
        String namespace = this.eventhubsConfig.namespace().orElseThrow(() -> new ConfigurationException("The namespace of Azure Event Hubs (quarkus.azure.eventhubs.namespace) must be set"));
        String domainName = this.eventhubsConfig.domainName().orElseThrow(() -> new ConfigurationException("The domain name of Azure Event Hubs (quarkus.azure.eventhubs.domain-name) must be set"));
        String eventhubName = this.eventhubsConfig.eventhubName().orElseThrow(() -> new ConfigurationException("The event hub name of Azure Event Hubs (quarkus.azure.eventhubs.eventhub-name) must be set"));
        return new EventHubClientBuilder().clientOptions(new ClientOptions().setApplicationId("az-qk-eventhubs")).credential(namespace + "." + domainName, eventhubName, (TokenCredential)new DefaultAzureCredentialBuilder().build());
    }
}

