/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.azure.core.http.vertx.runtime;

import com.azure.core.http.vertx.VertxProvider;
import io.vertx.core.Vertx;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.util.Set;

public class QuarkusVertxProvider
implements VertxProvider {
    public Vertx createVertx() {
        BeanManager beanManager = CDI.current().getBeanManager();
        Set beans = beanManager.getBeans(Vertx.class, new Annotation[0]);
        if (beans.isEmpty()) {
            throw new IllegalStateException("Failed to discover Vert.x bean from the CDI bean manager");
        }
        if (beans.size() > 1) {
            throw new IllegalStateException("Expected 1 Vert.x bean in the CDI bean manager but " + beans.size() + " were found");
        }
        Bean bean = beanManager.resolve(beans);
        Object reference = beanManager.getReference(bean, Vertx.class, beanManager.createCreationalContext((Contextual)bean));
        return (Vertx)reference;
    }
}

