/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.azure.identity.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.pkg.builditem.NativeImageRunnerBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import java.util.stream.Stream;

public class AzureIdentityProcessor {
    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    void runtimeInitializedClasses(BuildProducer<RuntimeInitializedClassBuildItem> runtimeInitializedClass) {
        Stream.of("com.microsoft.aad.msal4jextensions.persistence.linux.ISecurityLibrary", "com.microsoft.aad.msal4jextensions.persistence.mac.ISecurityLibrary").map(RuntimeInitializedClassBuildItem::new).forEach(arg_0 -> runtimeInitializedClass.produce(arg_0));
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    public void resources(BuildProducer<NativeImageResourceBuildItem> resource, NativeImageRunnerBuildItem nativeImageRunnerFactory) {
        String dir = "QMETA-INF/services";
        String hotspotLibName = "jdk.vm.ci.hotspot.HotSpotJVMCIBackendFactory";
        String jvmCiServiceLocatorLibName = "jdk.vm.ci.services.JVMCIServiceLocator";
        String hotspotLibPath = dir + "/" + hotspotLibName;
        String jvmCiServiceLocatorLibPath = dir + "/" + jvmCiServiceLocatorLibName;
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{hotspotLibPath}));
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{jvmCiServiceLocatorLibPath}));
        String jnaDir = "Qcom/sun/jna/linux-x86-64";
        String jniLibName = "libjnidispatch.so";
        String jniLibPath = jnaDir + "/" + jniLibName;
        resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{jniLibPath}));
    }
}

