/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.azure.keyvault.secret.runtime.config;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.vertx.VertxHttpClientBuilder;
import com.azure.core.util.ClientOptions;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.security.keyvault.secrets.SecretClient;
import com.azure.security.keyvault.secrets.SecretClientBuilder;
import com.azure.security.keyvault.secrets.models.KeyVaultSecretIdentifier;
import io.quarkiverse.azure.keyvault.secret.runtime.config.KeyVaultSecretConfig;
import io.quarkiverse.azure.keyvault.secret.runtime.config.KeyVaultSecretConfigUtil;
import io.smallrye.config.common.AbstractConfigSource;
import io.vertx.core.Vertx;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

class KeyVaultSecretConfigSource
extends AbstractConfigSource {
    private static final int KEYVAULT_SECRET_ORDINAL = 50;
    private static final String CONFIG_SOURCE_NAME = "io.quarkiverse.azure.keyvault.secret.runtime.config";
    private final KeyVaultSecretConfig kvConfig;
    private final SecretClientBuilder builder;

    public KeyVaultSecretConfigSource(KeyVaultSecretConfig kvConfig) {
        super(CONFIG_SOURCE_NAME, 50);
        this.kvConfig = kvConfig;
        this.builder = new SecretClientBuilder().clientOptions(new ClientOptions().setApplicationId("az-qk-kv-secret-sync")).credential((TokenCredential)new DefaultAzureCredentialBuilder().build());
    }

    private SecretClient createClient(String vaultUrl, Vertx vertx) {
        return this.builder.vaultUrl(vaultUrl).httpClient(new VertxHttpClientBuilder().vertx(vertx).build()).buildClient();
    }

    private Vertx createVertx() {
        return Vertx.vertx();
    }

    private void closeVertx(Vertx vertx) {
        try {
            vertx.close().toCompletionStage().toCompletableFuture().get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, String> getProperties() {
        return Collections.emptyMap();
    }

    public Set<String> getPropertyNames() {
        return Collections.emptySet();
    }

    public String getValue(String propertyName) {
        KeyVaultSecretIdentifier secretIdentifier = KeyVaultSecretConfigUtil.getSecretIdentifier(propertyName, this.kvConfig.endpoint().orElse(""));
        if (secretIdentifier == null) {
            return null;
        }
        Vertx vertx = this.createVertx();
        SecretClient client = this.createClient(secretIdentifier.getVaultUrl(), vertx);
        String secretValue = secretIdentifier.getVersion().equals("latest") ? client.getSecret(secretIdentifier.getName()).getValue() : client.getSecret(secretIdentifier.getName(), secretIdentifier.getVersion()).getValue();
        this.closeVertx(vertx);
        return secretValue;
    }
}

